/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.forge.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.sergo467.disablefog.forge.gui.components.CustomOptionsList;
import com.sergo467.disablefog.forge.gui.components.CustomStringWidget;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationScreen
extends Screen {
    protected final Screen parentScreen;
    protected final ForgeConfigSpec spec;
    protected final Set<? extends UnmodifiableConfig.Entry> entries;
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected boolean changed = false;
    @javax.annotation.Nullable
    protected CustomOptionsList list;
    protected final Options options;
    protected final Map<String, Object> valueSpecs;
    protected ArrayList<String> keylist;
    protected final ModContainer mod;
    protected final Runnable saveAction;
    protected final Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252780_(120).m_253136_();
    protected Button resetButton;
    public static final String LANG_PREFIX = "forgeconfigscreen.config.uitext.";
    private static final String RANGE_TOOLTIP = "forgeconfigscreen.config.uitext.rangetooltip";
    private static final ChatFormatting RANGE_TOOLTIP_STYLE = ChatFormatting.GRAY;
    public static final Component RESET = Component.m_237115_((String)"forgeconfigscreen.config.uitext.reset");
    public static final Component RESET_TOOLTIP = Component.m_237115_((String)"forgeconfigscreen.config.uitext.reset.tooltip");
    public static final Component BUTTON_ON = Component.m_237115_((String)"options.on").m_130940_(ChatFormatting.GREEN);
    public static final Component BUTTON_OFF = Component.m_237115_((String)"options.off").m_130940_(ChatFormatting.RED);
    public static final Component UNSUPPORTED_ELEMENT = Component.m_237115_((String)"forgeconfigscreen.config.uitext.unsupportedelement").m_130940_(ChatFormatting.RED);
    private static final MutableComponent EMPTY_LINE = Component.m_237113_((String)"\n\n");
    protected static final long MAX_SLIDER_SIZE = 256L;

    public ConfigurationScreen(ModContainer mod, Screen parentScreen, ForgeConfigSpec spec) {
        this(mod, parentScreen, spec, () -> ((ForgeConfigSpec)spec).save(), (Component)Component.m_237115_((String)(mod.getModId() + ".config.title")));
    }

    public ConfigurationScreen(ModContainer mod, Screen parentScreen, ForgeConfigSpec spec, Runnable saveAction, Component title) {
        super(title);
        this.options = Minecraft.m_91087_().f_91066_;
        this.mod = mod;
        this.parentScreen = parentScreen;
        this.spec = spec;
        this.saveAction = saveAction;
        this.entries = spec.getValues().entrySet();
        this.valueSpecs = spec.getSpec().valueMap();
    }

    protected void m_7856_() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.m_264036_();
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_267719_();
    }

    protected void m_267719_() {
        this.layout.m_264036_();
        if (this.list != null) {
            this.list.m_93437_(this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32);
        }
    }

    protected void rebuild() {
        if (this.list != null) {
            this.list.m_6702_().clear();
            for (UnmodifiableConfig.Entry entry : this.entries) {
                String key = entry.getKey();
                Object raw = entry.getRawValue();
                if (!(raw instanceof ForgeConfigSpec.ConfigValue)) continue;
                ForgeConfigSpec.ConfigValue cv = (ForgeConfigSpec.ConfigValue)raw;
                ForgeConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
                Element element = null;
                if (valueSpec != null) {
                    if (cv instanceof ForgeConfigSpec.BooleanValue) {
                        ForgeConfigSpec.BooleanValue booleanValue = (ForgeConfigSpec.BooleanValue)cv;
                        element = this.createBooleanValue(key, () -> ((ForgeConfigSpec.BooleanValue)booleanValue).get(), arg_0 -> ((ForgeConfigSpec.BooleanValue)booleanValue).set(arg_0));
                    } else if (cv instanceof ForgeConfigSpec.IntValue) {
                        ForgeConfigSpec.IntValue intValue = (ForgeConfigSpec.IntValue)cv;
                        element = this.createIntegerValue(key, valueSpec, () -> ((ForgeConfigSpec.IntValue)intValue).get(), arg_0 -> ((ForgeConfigSpec.IntValue)intValue).set(arg_0));
                    } else if (cv instanceof ForgeConfigSpec.LongValue) {
                        ForgeConfigSpec.LongValue longValue = (ForgeConfigSpec.LongValue)cv;
                        element = this.createLongValue(key, valueSpec, () -> ((ForgeConfigSpec.LongValue)longValue).get(), arg_0 -> ((ForgeConfigSpec.LongValue)longValue).set(arg_0));
                    } else if (cv instanceof ForgeConfigSpec.DoubleValue) {
                        ForgeConfigSpec.DoubleValue doubleValue = (ForgeConfigSpec.DoubleValue)cv;
                        element = this.createDoubleValue(key, valueSpec, () -> ((ForgeConfigSpec.DoubleValue)doubleValue).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)doubleValue).set(arg_0));
                    } else {
                        element = this.createOtherValue(key, cv);
                    }
                }
                if (element == null) continue;
                if (element.name() == null) {
                    this.list.addSmall((AbstractWidget)new CustomStringWidget(150, 20, (Component)Component.m_237119_(), this.f_96547_), element.getWidget(this.options));
                    continue;
                }
                CustomStringWidget label = new CustomStringWidget(150, 20, element.name(), this.f_96547_);
                if (element.tooltip() != null) {
                    label.m_257544_(Tooltip.m_257550_((Component)element.tooltip()));
                }
                AbstractWidget widget = element.getWidget(this.options);
                this.list.addSmall((AbstractWidget)label, widget);
            }
        }
        this.m_7787_((GuiEventListener)this.list);
        if (this.resetButton == null) {
            this.createResetButton();
        }
    }

    @Nullable
    protected Element createBooleanValue(String key, Supplier<Boolean> source, Consumer<Boolean> target) {
        MutableComponent label = this.getTranslationComponent(key);
        Component tooltip = this.getTooltipComponent(key, null);
        CycleButton button = CycleButton.m_168896_((Component)BUTTON_ON, (Component)BUTTON_OFF).m_168948_((Object)source.get()).m_168929_().m_168936_(0, 0, 150, 20, (Component)Component.m_237119_(), (btn, newValue) -> {
            target.accept((Boolean)newValue);
            this.onChanged();
        });
        button.m_257544_(Tooltip.m_257550_((Component)tooltip));
        return new Element((Component)label, tooltip, (AbstractWidget)button);
    }

    @Nullable
    protected Element createLongValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Long> source, Consumer<Long> target) {
        return this.createNumberBox(key, spec, source, target, null, Long::decode, 0L);
    }

    @Nullable
    protected Element createDoubleValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Double> source, Consumer<Double> target) {
        return this.createNumberBox(key, spec, source, target, null, Double::valueOf, 0.0);
    }

    @Nullable
    protected Element createIntegerValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Integer> source, Consumer<Integer> target) {
        int max;
        ForgeConfigSpec.Range range = spec.getRange();
        int min = range != null ? (Integer)range.getMin() : 0;
        int n = max = range != null ? (Integer)range.getMax() : Integer.MAX_VALUE;
        if ((long)max - (long)min < 256L) {
            return this.createSlider(key, source, target, (ForgeConfigSpec.Range<Integer>)range);
        }
        return this.createNumberBox(key, spec, source, target, null, Integer::decode, 0);
    }

    @Nullable
    protected Element createOtherValue(String key, ForgeConfigSpec.ConfigValue<?> value) {
        StringWidget label = new StringWidget(150, 20, (Component)Component.m_237113_((String)Objects.toString(value.get())), this.f_96547_).m_267769_();
        label.m_257544_(Tooltip.m_257550_((Component)UNSUPPORTED_ELEMENT));
        return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)label);
    }

    @Nullable
    protected <T extends Number> Element createNumberBox(String key, ForgeConfigSpec.ValueSpec spec, Supplier<T> source, Consumer<T> target, @Nullable Predicate<T> tester, Function<String, T> parser, T zero) {
        ForgeConfigSpec.Range range = spec.getRange();
        EditBox box = new EditBox(this.f_96547_, 150, 20, 0, 0, (Component)this.getTranslationComponent(key));
        box.m_94186_(true);
        box.m_94153_(newValueString -> {
            try {
                parser.apply((String)newValueString);
                return true;
            }
            catch (NumberFormatException e) {
                return this.isPartialNumber((String)newValueString, range == null || ((Comparable)((Object)((Number)((Object)range.getMin())))).compareTo(zero) < 0);
            }
        });
        box.m_257544_(Tooltip.m_257550_((Component)this.getTooltipComponent(key, range)));
        box.m_94144_(String.valueOf(source.get()));
        box.m_94151_(newValueString -> {
            try {
                Number newValue = (Number)parser.apply((String)newValueString);
                if (tester != null ? tester.test(newValue) : newValue != null && (range == null || range.test((Object)newValue)) && spec.test((Object)newValue)) {
                    if (!newValue.equals(source.get())) {
                        target.accept(newValue);
                        this.onChanged();
                    }
                    box.m_94202_(0xE0E0E0);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            box.m_94202_(-65536);
        });
        return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)box);
    }

    @Nullable
    protected Element createSlider(String key, Supplier<Integer> source, Consumer<Integer> target, @Nullable ForgeConfigSpec.Range<Integer> range) {
        return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new OptionInstance(this.getTranslationKey(key), this.getTooltip(key, range), (caption, displayvalue) -> Component.m_237113_((String)("" + displayvalue)), (OptionInstance.ValueSet)new OptionInstance.IntRange(range != null ? (Integer)range.getMin() : 0, range != null ? (Integer)range.getMax() : Integer.MAX_VALUE), null, (Object)source.get(), newValue -> {
            if (!newValue.equals(source.get())) {
                target.accept((Integer)newValue);
                this.onChanged();
            }
        }));
    }

    protected <T> OptionInstance.TooltipSupplier<T> getTooltip(String key, @Nullable ForgeConfigSpec.Range<?> range) {
        return OptionInstance.m_231535_((Component)this.getTooltipComponent(key, range));
    }

    protected Component getTooltipComponent(String key, @Nullable ForgeConfigSpec.Range<?> range) {
        String tooltipKey = this.getTranslationKey(key) + ".tooltip";
        String comment = this.getComment(key);
        MutableComponent component = Component.m_237119_().m_7220_((Component)this.getTranslationComponent(key).m_130940_(ChatFormatting.BOLD));
        if (!Strings.isBlank((String)comment)) {
            component = component.m_7220_((Component)EMPTY_LINE).m_7220_((Component)Component.m_264568_((String)tooltipKey, (String)comment));
        }
        if (range != null) {
            component = component.m_7220_((Component)EMPTY_LINE).m_7220_((Component)Component.m_237110_((String)RANGE_TOOLTIP, (Object[])new Object[]{range.toString()}).m_130940_(RANGE_TOOLTIP_STYLE));
        }
        return component;
    }

    protected String getComment(String key) {
        ForgeConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
        return valueSpec != null ? this.getValueSpec(key).getComment() : this.spec.getLevelComment(this.makeKeyList(key));
    }

    protected String getTranslationKey(String key) {
        ForgeConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
        String result = valueSpec != null ? valueSpec.getTranslationKey() : this.spec.getLevelTranslationKey(this.makeKeyList(key));
        return result != null ? result : this.mod.getModId() + ".config." + key;
    }

    protected MutableComponent getTranslationComponent(String key) {
        return Component.m_237115_((String)this.getTranslationKey(key));
    }

    private ArrayList<String> makeKeyList(String key) {
        ArrayList<String> result = new ArrayList<String>(this.keylist);
        result.add(key);
        return result;
    }

    protected boolean isPartialNumber(String value, boolean allowNegative) {
        return switch (value) {
            case "", "0X", "0", "0x" -> true;
            case "#" -> true;
            case "-", "-0", "-0x", "-0X" -> allowNegative;
            default -> false;
        };
    }

    protected void addContents() {
        this.list = new CustomOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, this);
        this.rebuild();
    }

    protected void addTitle() {
        this.layout.m_269471_((LayoutElement)new StringWidget(this.m_96636_(), this.f_96547_));
    }

    protected void addBaseFooter() {
        this.layout.m_269281_((LayoutElement)this.doneButton);
    }

    protected void addFooter() {
        if (this.resetButton != null) {
            LinearLayout linearlayout = (LinearLayout)this.layout.m_269281_((LayoutElement)new LinearLayout(248, 20, LinearLayout.Orientation.HORIZONTAL));
            if (this.resetButton != null) {
                linearlayout.m_264406_((LayoutElement)this.resetButton);
            }
            linearlayout.m_264406_((LayoutElement)this.doneButton);
        } else {
            this.addBaseFooter();
        }
    }

    protected void createResetButton() {
        this.resetButton = Button.m_253074_((Component)RESET, button -> {
            for (UnmodifiableConfig.Entry entry : this.entries) {
                ForgeConfigSpec.ConfigValue cv;
                Object patt0$temp = entry.getRawValue();
                if (!(patt0$temp instanceof ForgeConfigSpec.ConfigValue) || !this.isNonDefault(cv = (ForgeConfigSpec.ConfigValue)patt0$temp)) continue;
                cv.set(cv.getDefault());
                this.onChanged();
            }
            this.rebuild();
        }).m_257505_(Tooltip.m_257550_((Component)RESET_TOOLTIP)).m_252780_(120).m_253136_();
    }

    public void m_7379_() {
        if (this.changed) {
            this.saveAction.run();
        }
        if (this.f_96541_ == null) {
            throw new IllegalStateException("Minecraft instance is null in onClose()");
        }
        this.f_96541_.m_91152_(this.parentScreen);
    }

    protected void setResetButtonstate(boolean state) {
        if (this.resetButton != null) {
            this.resetButton.f_93623_ = state;
        }
    }

    protected void onChanged() {
        this.changed = true;
    }

    protected boolean isNonDefault(ForgeConfigSpec.ConfigValue<?> cv) {
        return !Objects.equals(cv.get(), cv.getDefault());
    }

    protected boolean isAnyNondefault() {
        for (UnmodifiableConfig.Entry entry : this.entries) {
            ForgeConfigSpec.ConfigValue cv;
            Object object = entry.getRawValue();
            if (!(object instanceof ForgeConfigSpec.ConfigValue) || !this.isNonDefault(cv = (ForgeConfigSpec.ConfigValue)object)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected ForgeConfigSpec.ValueSpec getValueSpec(String key) {
        Object object = this.valueSpecs.get(key);
        if (object instanceof ForgeConfigSpec.ValueSpec) {
            ForgeConfigSpec.ValueSpec vs = (ForgeConfigSpec.ValueSpec)object;
            return vs;
        }
        return null;
    }

    public void m_88315_(@NotNull GuiGraphics g, int i, int j, float f) {
        if (this.f_96541_.f_91073_ == null) {
            this.m_280039_(g);
        } else {
            g.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        }
        if (this.list != null) {
            this.list.m_88315_(g, i, j, f);
        }
        this.setResetButtonstate(this.isAnyNondefault());
        super.m_88315_(g, i, j, f);
    }

    public record Element(@Nullable Component name, @Nullable Component tooltip, @Nullable AbstractWidget widget, @Nullable OptionInstance<?> option) {
        public Element(@Nullable Component name, @Nullable Component tooltip, AbstractWidget widget) {
            this(name, tooltip, widget, null);
        }

        public Element(Component name, Component tooltip, OptionInstance<?> option) {
            this(name, tooltip, null, option);
        }

        public AbstractWidget getWidget(Options options) {
            return this.widget != null ? this.widget : this.option.m_231507_(options, 5, 5, 5);
        }
    }
}

