/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.mixin;

import com.sergo467.disablefog.config.ConfigManager;
import com.sergo467.disablefog.config.IFogConfig;
import com.sergo467.disablefog.mixin.FogDataAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Redirect(method={"setupFog"}, at=@At(value="INVOKE", target="net/minecraft/client/Camera.getFluidInCamera ()Lnet/minecraft/world/level/material/FogType;"))
    private static FogType redirectGetFluidInCamera(Camera camera) {
        IFogConfig config = ConfigManager.getConfig();
        FogType cameraSubmersionType = camera.m_167685_();
        if (!config.isEnabled()) {
            return cameraSubmersionType;
        }
        if (cameraSubmersionType == FogType.LAVA && !config.isLavaEnabled()) {
            return FogType.NONE;
        }
        if (cameraSubmersionType == FogType.POWDER_SNOW && !config.isPowderSnowEnabled()) {
            return FogType.NONE;
        }
        if (cameraSubmersionType == FogType.WATER && !config.isWaterEnabled()) {
            return FogType.NONE;
        }
        return cameraSubmersionType;
    }

    @ModifyVariable(method={"setupFog"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private static boolean disableThickFog(boolean shouldCreateFog) {
        IFogConfig config = ConfigManager.getConfig();
        if (config.isEnabled() && !config.isThickEnabled()) {
            return false;
        }
        return shouldCreateFog;
    }

    @Inject(method={"setupFog"}, slice={@Slice(from=@At(value="FIELD", target="net/minecraft/client/renderer/FogRenderer$FogMode.FOG_SKY : Lnet/minecraft/client/renderer/FogRenderer$FogMode;", opcode=178), to=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp (FFF)F"))}, at={@At(value="FIELD", target="net/minecraft/client/renderer/FogRenderer$FogData.shape : Lcom/mojang/blaze3d/shaders/FogShape;", opcode=181, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void disableSkyFog(Camera camera, FogRenderer.FogMode fogMode, float farPlaneDistance, boolean shouldCreateFog, float partialTick, CallbackInfo ci, FogType fogType, Entity entity, @Coerce FogDataAccessor fogData) {
        IFogConfig config = ConfigManager.getConfig();
        if (config.isEnabled() && !config.isSkyEnabled()) {
            fogData.setStart(Float.MAX_VALUE);
            fogData.setEnd(Float.MAX_VALUE);
        }
    }

    @Inject(method={"setupFog"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp (FFF)F"))}, at={@At(value="FIELD", target="net/minecraft/client/renderer/FogRenderer$FogData.shape : Lcom/mojang/blaze3d/shaders/FogShape;", opcode=181, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void disableTerrainFog(Camera camera, FogRenderer.FogMode fogMode, float farPlaneDistance, boolean shouldCreateFog, float partialTick, CallbackInfo ci, FogType fogType, Entity entity, @Coerce FogDataAccessor fogData) {
        IFogConfig config = ConfigManager.getConfig();
        if (config.isEnabled() && !config.isTerrainEnabled()) {
            fogData.setStart(Float.MAX_VALUE);
            fogData.setEnd(Float.MAX_VALUE);
        }
    }
}

