/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.mixin;

import com.sergo467.disablefog.DisableFogMod;
import com.sergo467.disablefog.utils.ModDetection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class DisableFogMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = DisableFogMod.LOGGER;
    private static boolean logged = false;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!logged) {
            if (ModDetection.IRIS) {
                LOGGER.debug("Iris detected, applying dependent mixins");
            } else if (ModDetection.OCULUS) {
                LOGGER.debug("Oculus detected, applying dependent mixins");
            } else {
                LOGGER.debug("Iris or Oculus not found, skipping dependent mixins");
            }
            logged = true;
        }
        if (mixinClassName.endsWith("CommonUniformsMixin") || mixinClassName.endsWith("ReplaceIrisPreRenderSky")) {
            return ModDetection.IRIS || ModDetection.OCULUS;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (!mixinClassName.endsWith("ReplaceIrisPreRenderSky")) {
            return;
        }
        MethodNode method = null;
        for (MethodNode mn : targetClass.methods) {
            if (!mn.name.startsWith("handler$") || !mn.name.endsWith("$preRenderSky")) continue;
            method = mn;
            LOGGER.debug("Found synthetic Iris method: {}", (Object)method.name);
            break;
        }
        if (method == null) {
            return;
        }
        for (MethodNode mn : targetClass.methods) {
            AbstractInsnNode insn = mn.instructions.getFirst();
            while (insn != null) {
                AbstractInsnNode next = insn.getNext();
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode call = (MethodInsnNode)insn;
                    if (call.name.equals(method.name)) {
                        LOGGER.debug("Removing call to {} in method {}", (Object)method.name, (Object)mn.name);
                        mn.instructions.remove(insn);
                    }
                }
                insn = next;
            }
        }
        targetClass.methods.remove(method);
        LOGGER.debug("Removed synthetic method: {}", (Object)method.name);
    }
}

