/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.mixin;

import com.sergo467.disablefog.config.ConfigManager;
import com.sergo467.disablefog.config.IFogConfig;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.client.renderer.fog.environment.AtmosphericFogEnvironment;
import net.minecraft.client.renderer.fog.environment.BlindnessFogEnvironment;
import net.minecraft.client.renderer.fog.environment.DarknessFogEnvironment;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.client.renderer.fog.environment.LavaFogEnvironment;
import net.minecraft.client.renderer.fog.environment.PowderedSnowFogEnvironment;
import net.minecraft.client.renderer.fog.environment.WaterFogEnvironment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Redirect(method={"computeFogColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/fog/environment/FogEnvironment;isApplicable(Lnet/minecraft/world/level/material/FogType;Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean overrideColorApplicability(FogEnvironment env, FogType type, Entity entity) {
        IFogConfig CONFIG = ConfigManager.getConfig();
        if (!CONFIG.isEnabled()) {
            return env.isApplicable(type, entity);
        }
        if (env instanceof BlindnessFogEnvironment && !CONFIG.isBlindnessEnabled()) {
            return false;
        }
        if (env instanceof DarknessFogEnvironment && !CONFIG.isDarknessEnabled()) {
            return false;
        }
        return env.isApplicable(type, entity);
    }

    @Redirect(method={"setupFog"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/fog/environment/FogEnvironment;isApplicable(Lnet/minecraft/world/level/material/FogType;Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean overrideShouldApply(FogEnvironment env, FogType type, Entity entity) {
        IFogConfig CONFIG = ConfigManager.getConfig();
        if (!CONFIG.isEnabled()) {
            return env.isApplicable(type, entity);
        }
        if (env instanceof LavaFogEnvironment && !CONFIG.isLavaEnabled()) {
            return false;
        }
        if (env instanceof PowderedSnowFogEnvironment && !CONFIG.isPowderSnowEnabled()) {
            return false;
        }
        if (env instanceof BlindnessFogEnvironment && !CONFIG.isBlindnessEnabled()) {
            return false;
        }
        if (env instanceof DarknessFogEnvironment && !CONFIG.isDarknessEnabled()) {
            return false;
        }
        if (env instanceof WaterFogEnvironment && !CONFIG.isWaterEnabled()) {
            return false;
        }
        if (env instanceof AtmosphericFogEnvironment && !CONFIG.isAtmosphericEnabled()) {
            return false;
        }
        return env.isApplicable(type, entity);
    }

    @Redirect(method={"setupFog"}, at=@At(value="NEW", target="net/minecraft/client/renderer/fog/FogData"))
    private FogData overrideFogDataConstructor() {
        IFogConfig CONFIG = ConfigManager.getConfig();
        FogData fogData = new FogData();
        if (!CONFIG.isEnabled()) {
            return fogData;
        }
        fogData.environmentalStart = Float.MAX_VALUE;
        fogData.environmentalEnd = Float.MAX_VALUE;
        fogData.renderDistanceStart = Float.MAX_VALUE;
        fogData.renderDistanceEnd = Float.MAX_VALUE;
        fogData.skyEnd = Float.MAX_VALUE;
        fogData.cloudEnd = Float.MAX_VALUE;
        return fogData;
    }

    @ModifyVariable(method={"setupFog"}, at=@At(value="FIELD", target="net/minecraft/client/renderer/fog/FogData.renderDistanceEnd : F", opcode=181, shift=At.Shift.AFTER))
    private FogData disableTerrainFog(FogData fogData) {
        IFogConfig CONFIG = ConfigManager.getConfig();
        if (CONFIG.isEnabled() && !CONFIG.isTerrainEnabled()) {
            fogData.renderDistanceStart = Float.MAX_VALUE;
            fogData.renderDistanceEnd = Float.MAX_VALUE;
        }
        return fogData;
    }
}

