/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.mixin.iris;

import com.sergo467.disablefog.config.ConfigManager;
import com.sergo467.disablefog.config.IFogConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.irisshaders.iris.uniforms.CommonUniforms"}, remap=false)
public class CommonUniformsMixin {
    @Inject(method={"getBlindness"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void disableFogBlindness(CallbackInfoReturnable<Float> cir) {
        IFogConfig config = ConfigManager.getConfig();
        if (config.isEnabled() && !config.isBlindnessEnabled()) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"getDarknessFactor"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void disableFogDarkness(CallbackInfoReturnable<Float> cir) {
        IFogConfig config = ConfigManager.getConfig();
        if (config.isEnabled() && !config.isDarknessEnabled()) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"isEyeInWater"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void onIsEyeInWater(CallbackInfoReturnable<Integer> cir) {
        IFogConfig config = ConfigManager.getConfig();
        if (!config.isEnabled()) {
            return;
        }
        FogType type = Minecraft.getInstance().gameRenderer.getMainCamera().getFluidInCamera();
        if (type == FogType.WATER && !config.isWaterEnabled()) {
            cir.setReturnValue((Object)0);
            return;
        }
        if (type == FogType.LAVA && !config.isLavaEnabled()) {
            cir.setReturnValue((Object)0);
            return;
        }
        if (type == FogType.POWDER_SNOW && !config.isPowderSnowEnabled()) {
            cir.setReturnValue((Object)0);
            return;
        }
    }
}

