/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.neoforge.config;

import com.sergo467.disablefog.config.FogConfigDefault;
import com.sergo467.disablefog.config.IFogConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeFogConfig
implements IFogConfig {
    private final ModConfigSpec.BooleanValue enabled;
    private final ModConfigSpec.BooleanValue terrain;
    private final ModConfigSpec.BooleanValue atmospheric;
    private final ModConfigSpec.BooleanValue water;
    private final ModConfigSpec.BooleanValue lava;
    private final ModConfigSpec.BooleanValue powderSnow;
    private final ModConfigSpec.BooleanValue blindness;
    private final ModConfigSpec.BooleanValue darkness;

    public NeoForgeFogConfig(ModConfigSpec.Builder builder) {
        FogConfigDefault defaults = new FogConfigDefault();
        builder.comment("DisableFog configuration settings");
        this.enabled = builder.comment("Enables or disables the mod, affecting all fog settings").translation("config.disablefog.enabled").define("enabled", defaults.isEnabled());
        this.terrain = builder.translation("config.disablefog.terrain.tooltip").comment("Toggles terrain fog visibility, improving visibility of distant landscapes").translation("config.disablefog.terrain").define("terrain", defaults.isTerrainEnabled());
        this.atmospheric = builder.translation("config.disablefog.atmospheric.tooltip").comment("Toggles haze that covers the world and also changes the sky's appearance").translation("config.disablefog.atmospheric").define("atmospheric", defaults.isAtmosphericEnabled());
        this.water = builder.translation("config.disablefog.water.tooltip").comment("Toggles underwater fog visibility, improving visibility below water").translation("config.disablefog.water").define("water", defaults.isWaterEnabled());
        this.lava = builder.translation("config.disablefog.lava.tooltip").comment("Toggles lava fog visibility, improving visibility beneath lava").translation("config.disablefog.lava").define("lava", defaults.isLavaEnabled());
        this.powderSnow = builder.translation("config.disablefog.powder_snow.tooltip").comment("Toggles fog visibility when sinking into powder snow, improving visibility in snowy areas").translation("config.disablefog.powder_snow").define("powderSnow", defaults.isPowderSnowEnabled());
        this.blindness = builder.translation("config.disablefog.blindness.tooltip").comment("Toggles blindness fog visibility, improving visibility during the blindness effect").translation("config.disablefog.blindness").define("blindness", defaults.isBlindnessEnabled());
        this.darkness = builder.translation("config.disablefog.darkness.tooltip").comment("Toggles darkness fog visibility, improving visibility during the darkness effect").translation("config.disablefog.darkness").define("darkness", defaults.isDarknessEnabled());
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    @Override
    public boolean isTerrainEnabled() {
        return (Boolean)this.terrain.get();
    }

    @Override
    public boolean isAtmosphericEnabled() {
        return (Boolean)this.atmospheric.get();
    }

    @Override
    public boolean isWaterEnabled() {
        return (Boolean)this.water.get();
    }

    @Override
    public boolean isLavaEnabled() {
        return (Boolean)this.lava.get();
    }

    @Override
    public boolean isPowderSnowEnabled() {
        return (Boolean)this.powderSnow.get();
    }

    @Override
    public boolean isBlindnessEnabled() {
        return (Boolean)this.blindness.get();
    }

    @Override
    public boolean isDarknessEnabled() {
        return (Boolean)this.darkness.get();
    }
}

