/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"playerstats");
    public static final DeferredHolder<Attribute, Attribute> FOLLOW_OWNER = ATTRIBUTES.register("follow_owner", () -> new RangedAttribute("attribute.playerstats.follow_owner", -1.0, -1.0, 1.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> TELEPORT_TO_OWNER = ATTRIBUTES.register("teleport_to_owner", () -> new RangedAttribute("attribute.playerstats.teleport_to_owner", -1.0, -1.0, 1.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> LIFE_REGEN = ATTRIBUTES.register("life_regen", () -> new RangedAttribute("attribute.playerstats.life_regen", -1.0, -1.0, 1.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> FROST_WALKER = ATTRIBUTES.register("frost_walker", () -> new RangedAttribute("attribute.playerstats.frost_walker", -1.0, -1.0, 1.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> DEFEND_OWNER = ATTRIBUTES.register("defend_owner", () -> new RangedAttribute("attribute.playerstats.defend_owner", -1.0, -1.0, 1.0).setSyncable(true));

    @SubscribeEvent
    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            if (type == EntityType.PLAYER) continue;
            event.add(type, LIFE_REGEN.getDelegate());
            if (type == EntityType.HORSE || type == EntityType.DONKEY || type == EntityType.MULE) {
                event.add(type, FOLLOW_OWNER.getDelegate());
                event.add(type, TELEPORT_TO_OWNER.getDelegate());
                event.add(type, FROST_WALKER.getDelegate());
            }
            if (type != EntityType.IRON_GOLEM) continue;
            event.add(type, FOLLOW_OWNER.getDelegate());
            event.add(type, TELEPORT_TO_OWNER.getDelegate());
            event.add(type, DEFEND_OWNER.getDelegate());
        }
    }
}

