/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import com.playerstats.entities.goals.DefendOwnerTargetGoal;
import com.playerstats.entities.goals.FollowOwnerGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="playerstats")
public class ModAbilityEvents {
    @SubscribeEvent
    public static void onHorseTamed(AnimalTameEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)livingEntity;
            horse.getPersistentData().putUUID("Owner", event.getTamer().getUUID());
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal((Mob)horse));
        }
        if ((entity = event.getEntity()) instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            golem.targetSelector.addGoal(1, (Goal)new DefendOwnerTargetGoal(golem));
            golem.targetSelector.addGoal(3, (Goal)new FollowOwnerGoal((Mob)golem));
        }
    }

    @SubscribeEvent
    public static void onHorseTick(PlayerTickEvent.Post event) {
        try {
            Entity entity = event.getEntity().getVehicle();
            if (!(entity instanceof AbstractHorse)) {
                return;
            }
            AbstractHorse horse = (AbstractHorse)entity;
            Level level = horse.level();
            if (level.isClientSide) {
                return;
            }
            if (horse.getAttributes().getInstance(ModAttributes.FROST_WALKER.getDelegate()).getValue() == 1.0) {
                BlockPos pos = horse.blockPosition();
                boolean frostLevel = true;
                ModAbilityEvents.applyFrostWalker((Entity)horse, horse.level(), horse.blockPosition(), 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void applyFrostWalker(Entity entity, Level level, BlockPos pos, int levelFrost) {
        if (!entity.onGround()) {
            return;
        }
        BlockState frostedIce = Blocks.FROSTED_ICE.defaultBlockState();
        float radius = Math.min(16, 2 + levelFrost);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset((int)(-radius), -1, (int)(-radius)), (BlockPos)pos.offset((int)radius, -1, (int)radius))) {
            BlockState state;
            if (!blockpos.closerToCenterThan((Position)entity.position(), (double)radius)) continue;
            mutable.set(blockpos.getX(), blockpos.getY() + 1, blockpos.getZ());
            if (!level.getBlockState((BlockPos)mutable).isAir() || (state = level.getBlockState(blockpos)).getBlock() != Blocks.WATER || (Integer)state.getValue((Property)LiquidBlock.LEVEL) != 0 || !frostedIce.canSurvive((LevelReader)level, blockpos) || !level.isUnobstructed(frostedIce, blockpos, CollisionContext.empty())) continue;
            level.setBlockAndUpdate(blockpos, frostedIce);
            level.scheduleTick(blockpos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)entity.getRandom(), (int)60, (int)120));
        }
    }
}

