/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.client.ClientAttributeCache;
import com.playerstats.client.KeyMappings;
import com.playerstats.network.PacketHandler;
import com.playerstats.network.UpdatePointsPacket;
import com.playerstats.network.UpdateUpgradeCountPacket;
import com.playerstats.util.AttributeUtils;
import com.playerstats.util.UniqueAbilitiesUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerAttributePersistence {
    private static final String ATTRIBUTE_UPGRADES_TAG = "PlayerStatsUpgrades";
    private static final String POINTS_TAG = "PlayerStatsPoints";
    private static final String UPGRADE_COUNT_TAG = "PlayerStatsUpgradeCount";
    private static final String ABILITY_POINTS_TAG = "PlayerAbilityPoints";

    public static void register() {
        NeoForge.EVENT_BUS.register(PlayerAttributePersistence.class);
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        CompoundTag originalNBT = event.getOriginal().getPersistentData();
        Player player = event.getEntity();
        ClientAttributeCache.clean();
        CompoundTag root = player.getPersistentData();
        root.put(ATTRIBUTE_UPGRADES_TAG, (Tag)originalNBT.getCompound(ATTRIBUTE_UPGRADES_TAG));
        if (((Boolean)Config.RESET_ON_DEATH.get()).booleanValue()) {
            PlayerAttributePersistence.resetAttributes((LivingEntity)player, (ServerPlayer)player, true);
        } else {
            PlayerAttributePersistence.setPoints(player, PlayerAttributePersistence.getPoints(event.getOriginal()));
            PlayerAttributePersistence.setAbilityPoints(player, PlayerAttributePersistence.getPoints(event.getOriginal()));
            CompoundTag upgradesTag = root.getCompound(ATTRIBUTE_UPGRADES_TAG);
            for (String key : upgradesTag.getAllKeys()) {
                ResourceLocation id = ResourceLocation.tryParse((String)key);
                Attribute attr = (Attribute)BuiltInRegistries.ATTRIBUTE.get(id);
                AttributeInstance instance = AttributeUtils.getAttributeInstance((LivingEntity)player, attr);
                if (attr == null || instance == null) continue;
                int upgradeCount = upgradesTag.getInt(key);
                double increment = AttributeUtils.getIncrement(attr.getDescriptionId());
                PlayerStats.LOGGER.info("Configurando atributo:" + attr.getDescriptionId() + " valor atual: " + instance.getBaseValue() + " upgrade count: " + upgradeCount + " increment: " + increment);
                double totalIncrement = (double)upgradeCount * increment;
                PlayerAttributePersistence.applyModifier(instance, attr.getDescriptionId(), totalIncrement);
            }
        }
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(PlayerAttributePersistence.getUpgradeCount((LivingEntity)player)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ClientAttributeCache.clean();
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getPoints(player), "attribute"), (ServerPlayer)player);
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getAbilityPoints(player), "ability"), (ServerPlayer)player);
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(PlayerAttributePersistence.getUpgradeCount((LivingEntity)player)), (ServerPlayer)player);
    }

    public static void upgradeAttribute(LivingEntity entity, ServerPlayer player, String attributeId) {
        ResourceLocation id = ResourceLocation.tryParse((String)attributeId);
        Attribute attr = (Attribute)BuiltInRegistries.ATTRIBUTE.get(id);
        if (attr != null) {
            AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, attr);
            if (!attributeId.startsWith("playerstats:")) {
                int playerPoints = PlayerAttributePersistence.getPoints((Player)player);
                int playerUpgrades = PlayerAttributePersistence.getUpgradeCount(entity);
                int xpIncrement = (Integer)Config.XP_COST_INCREMENT.get();
                int xpCost = (playerUpgrades + 1) * xpIncrement;
                boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
                if (player.gameMode.getGameModeForPlayer() == GameType.CREATIVE) {
                    consumeXp = false;
                }
                if (instance == null) {
                    System.err.println("AttributeInstance is null for: " + String.valueOf(id));
                    return;
                }
                if (!(playerPoints <= 0 || player.experienceLevel < xpCost && consumeXp)) {
                    PlayerAttributePersistence.applyUpgrade(entity, attr);
                    PlayerAttributePersistence.setPoints((Player)player, playerPoints - 1);
                    PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getPoints((Player)player), "attribute"), player);
                    int count = PlayerAttributePersistence.getUpgradeCount(entity);
                    PacketHandler.sendToClient(new UpdateUpgradeCountPacket(count), player);
                    if (consumeXp) {
                        PlayerAttributePersistence.consumeExperience((Player)player, xpCost);
                    }
                }
            } else {
                int playerPoints = PlayerAttributePersistence.getAbilityPoints((Player)player);
                if (instance.getValue() == -1.0) {
                    int xpCost = (Integer)Config.REQUIRED_XP_FOR_ABILITY.get();
                    boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
                    if (player.gameMode.getGameModeForPlayer() == GameType.CREATIVE) {
                        consumeXp = false;
                    }
                    if (!(playerPoints <= 0 || player.experienceLevel < xpCost && consumeXp)) {
                        if (!UniqueAbilitiesUtils.enableDisableAbility(entity, (Player)player, attributeId, true)) {
                            return;
                        }
                        PlayerAttributePersistence.applyModifier(instance, attr.getDescriptionId(), 2.0);
                        PlayerAttributePersistence.setAbilityPoints((Player)player, playerPoints - 1);
                        if (consumeXp) {
                            PlayerAttributePersistence.consumeExperience((Player)player, xpCost);
                        }
                    }
                } else if (instance.getValue() == 0.0) {
                    UniqueAbilitiesUtils.enableDisableAbility(entity, (Player)player, attributeId, true);
                    PlayerAttributePersistence.applyModifier(instance, attr.getDescriptionId(), 2.0);
                } else if (instance.getValue() == 1.0) {
                    UniqueAbilitiesUtils.enableDisableAbility(entity, (Player)player, attributeId, false);
                    PlayerAttributePersistence.applyModifier(instance, attr.getDescriptionId(), 1.0);
                }
            }
        } else {
            System.err.println("Unknown attribute ID: " + String.valueOf(id));
        }
    }

    public static void applyUpgrade(LivingEntity player, Attribute attr) {
        ResourceLocation key = BuiltInRegistries.ATTRIBUTE.getKey((Object)attr);
        CompoundTag upgrades = player.getPersistentData().getCompound(ATTRIBUTE_UPGRADES_TAG);
        int currentUpgrades = upgrades.getInt(key.toString()) + 1;
        upgrades.putInt(key.toString(), currentUpgrades);
        player.getPersistentData().put(ATTRIBUTE_UPGRADES_TAG, (Tag)upgrades);
        AttributeInstance instance = AttributeUtils.getAttributeInstance(player, attr);
        if (instance != null) {
            double increment = AttributeUtils.getIncrement(attr.getDescriptionId());
            PlayerAttributePersistence.applyModifier(instance, attr.getDescriptionId(), increment * (double)currentUpgrades);
        }
    }

    public static void resetAttributes(LivingEntity entity, ServerPlayer player, boolean resetByDeath) {
        boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
        int requiredXp = (Integer)Config.REQUIRED_XP_FOR_RESET.get();
        if (player.experienceLevel < requiredXp && player.gameMode.getGameModeForPlayer() != GameType.CREATIVE && !resetByDeath && consumeXp) {
            player.sendSystemMessage((Component)Component.translatable((String)"gui.playerstats.cant_reset", (Object[])new Object[]{requiredXp}));
            return;
        }
        CompoundTag upgrades = entity.getPersistentData().getCompound(ATTRIBUTE_UPGRADES_TAG);
        int refundedPoints = 0;
        for (String key : upgrades.getAllKeys()) {
            ResourceLocation id = ResourceLocation.tryParse((String)key);
            Attribute attr = (Attribute)BuiltInRegistries.ATTRIBUTE.get(id);
            AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, attr);
            if (attr == null || instance == null) continue;
            int upgradesApplied = upgrades.getInt(key);
            instance.getModifiers().stream().filter(mod -> mod.id().getNamespace().equals("playerstats") && mod.id().getPath().equals(attr.getDescriptionId())).toList().forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
            refundedPoints += upgradesApplied;
        }
        entity.getPersistentData().remove(ATTRIBUTE_UPGRADES_TAG);
        entity.getPersistentData().remove(UPGRADE_COUNT_TAG);
        if (!resetByDeath) {
            PlayerAttributePersistence.setPoints((Player)player, PlayerAttributePersistence.getPoints((Player)player) + refundedPoints);
            if (consumeXp) {
                PlayerAttributePersistence.consumeExperience((Player)player, requiredXp);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"gui.playerstats.reset", (Object[])new Object[]{refundedPoints}));
        }
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(0), player);
    }

    public static void consumeExperience(Player player, int level) {
        int points = level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        player.giveExperiencePoints(points * -1);
    }

    private static void applyModifier(AttributeInstance instance, String attrId, double value) {
        instance.getModifiers().stream().filter(mod -> mod.id().getNamespace().equals("playerstats") && mod.id().getPath().equals(attrId)).toList().forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
        ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)attrId);
        AttributeModifier modifier = new AttributeModifier(modifierId, value, AttributeModifier.Operation.ADD_VALUE);
        instance.addPermanentModifier(modifier);
    }

    public static int getPoints(Player player) {
        return player.getPersistentData().getInt(POINTS_TAG);
    }

    public static void setPoints(Player player, int points) {
        player.getPersistentData().putInt(POINTS_TAG, points);
        PacketHandler.sendToClient(new UpdatePointsPacket(points, "attribute"), (ServerPlayer)player);
    }

    public static int getAbilityPoints(Player player) {
        return player.getPersistentData().getInt(ABILITY_POINTS_TAG);
    }

    public static void setAbilityPoints(Player player, int points) {
        player.getPersistentData().putInt(ABILITY_POINTS_TAG, points);
        PacketHandler.sendToClient(new UpdatePointsPacket(points, "ability"), (ServerPlayer)player);
    }

    public static void addPoints(Player player, int points) {
        CompoundTag tag = player.getPersistentData();
        int playerPoints = tag.getInt(POINTS_TAG) + points;
        tag.putInt(POINTS_TAG, playerPoints);
        PacketHandler.sendToClient(new UpdatePointsPacket(playerPoints, "attribute"), (ServerPlayer)player);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.playerstats.ability_point_given", (Object[])new Object[]{((KeyMapping)KeyMappings.OPEN_STATS_KEY.get()).getKey().getDisplayName()}));
        }
    }

    public static void addAbilityPoints(Player player, int points) {
        CompoundTag tag = player.getPersistentData();
        int playerPoints = tag.getInt(ABILITY_POINTS_TAG) + points;
        tag.putInt(ABILITY_POINTS_TAG, playerPoints);
        PacketHandler.sendToClient(new UpdatePointsPacket(playerPoints, "ability"), (ServerPlayer)player);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.playerstats.ability_point_given", (Object[])new Object[]{((KeyMapping)KeyMappings.OPEN_STATS_KEY.get()).getKey().getDisplayName()}));
        }
    }

    public static int getUpgradeCount(LivingEntity entity) {
        return entity.getPersistentData().getInt(UPGRADE_COUNT_TAG);
    }
}

