/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.event.PlayerAttributePersistence;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="playerstats")
public class PlayerPointHandler {
    private static final Map<UUID, Long> lastDayPointGiven = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int totalKills = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.MOB_KILLS));
        if (totalKills > 0 && (totalKills == 100 || totalKills % 1000 == 0)) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.playerstats.mobs_killed", (Object[])new Object[]{totalKills}));
            PlayerPointHandler.givePoints(player, 1);
        }
        LivingEntity mob = event.getEntity();
        double baseChance = 0.0;
        if (mob.getType() == EntityType.WITHER || mob.getType() == EntityType.ENDER_DRAGON) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Wither/Ender dragon morto!");
            }
            baseChance = 0.5;
        } else if (mob.getType() == EntityType.WARDEN) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Warden morto!");
            }
            baseChance = 0.3;
        } else if (mob.getType() == EntityType.ELDER_GUARDIAN) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Elder guardian morto!");
            }
            baseChance = 0.3;
        } else if (mob.getMaxHealth() > 200.0f) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob com mais de 200 de vida morto: {}", (Object)mob.getType());
            }
            baseChance = 0.05;
        }
        if (Config.cachedCustomMobChances.containsKey(mob.getType().getDescriptionId())) {
            baseChance = Config.cachedCustomMobChances.get(mob.getType().getDescriptionId());
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob customizado morto: {}, chance configurada: {}", (Object)mob.getType(), (Object)baseChance);
            }
        }
        if (baseChance == 0.0) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob morto sem chances de pontos: {}", (Object)mob.getType());
            }
            return;
        }
        PlayerPointHandler.processChance(player, baseChance);
    }

    private static void processChance(ServerPlayer player, double baseChance) {
        if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
            PlayerStats.LOGGER.info("Chances de ponto: {}", (Object)baseChance);
        }
        if (player.level().random.nextDouble() < baseChance) {
            PlayerPointHandler.givePoints(player, 1);
        }
    }

    private static void givePoints(ServerPlayer player, int amount) {
        long currentDay = player.level().getDayTime() / 24000L;
        UUID uuid = player.getUUID();
        Long lastGiven = lastDayPointGiven.getOrDefault(uuid, -1L);
        if (lastGiven == currentDay) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Player {} j\u00e1 recebeu pontos hoje, ignorando.", (Object)player.getName());
            }
            return;
        }
        lastDayPointGiven.put(uuid, currentDay);
        PlayerAttributePersistence.addPoints((Player)player, amount);
    }
}

