/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.playerstats.Config;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public class AttributeSuggestions {
    public static final SuggestionProvider<CommandSourceStack> EDITABLE_ATTRIBUTE_IDS = (context, builder) -> {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            return Suggestions.empty();
        }
        for (Attribute attr : BuiltInRegistries.ATTRIBUTE) {
            AttributeInstance instance;
            ResourceLocation id = BuiltInRegistries.ATTRIBUTE.getKey((Object)attr);
            if (id == null) continue;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)id);
            Holder.Reference holder = player.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(key).orElse(null);
            if (holder == null || (instance = player.getAttributes().getInstance((Holder)holder)) == null || !attr.isClientSyncable() || Config.cachedIgnoredAttributes.contains(attr.getDescriptionId())) continue;
            builder.suggest(id.toString());
        }
        return builder.buildFuture();
    };
}

