/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.client.ClientAttributeCache;
import com.playerstats.network.ModifyAttributePacket;
import com.playerstats.network.PacketHandler;
import com.playerstats.network.ResetAttributesPacket;
import com.playerstats.util.AttributeUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class StatsScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("playerstats", "textures/gui/stats_background.png");
    private static final int BG_WIDTH = 255;
    private static final int BG_HEIGHT = 255;
    private static final int SCROLL_STEP = 10;
    private static final int LINE_HEIGHT = 15;
    private int leftPos;
    private int topPos;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int clipTop;
    private int clipBottom;
    private Button resetButton;
    private EditBox searchBox;
    private String searchText = "";

    public StatsScreen() {
        super((Component)Component.m_237113_((String)"Player Stats"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 255) / 2;
        this.topPos = (this.f_96544_ - 255) / 2;
        this.clipTop = this.topPos + 62;
        this.clipBottom = this.topPos + 255 - 55;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 36, 120, 14, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(text -> {
            this.searchText = text.toLowerCase();
            this.scrollOffset = 0;
            this.rebuildButtons();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.playerstats.reset"), btn -> PacketHandler.sendToServer(new ResetAttributesPacket())).m_252987_(this.leftPos + 127 - 35, this.topPos + 255 - 30, 70, 20).m_253136_();
        this.rebuildButtons();
    }

    private void rebuildButtons() {
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.searchBox);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        List<Attribute> filteredAttributes = BuiltInRegistries.f_256951_.m_123024_().filter(arg_0 -> this.lambda$rebuildButtons$2((Player)player, arg_0)).toList();
        int visibleLines = (this.clipBottom - this.clipTop) / 15;
        this.maxScroll = Math.max(0, (filteredAttributes.size() - visibleLines) * 15);
        int y = this.clipTop - this.scrollOffset;
        for (Attribute attr : filteredAttributes) {
            int plusButtonPos;
            AttributeInstance attribute = player.m_21204_().m_22146_(attr);
            if (y + 12 < this.clipTop) {
                y += 15;
                continue;
            }
            if (y + 2 > this.clipBottom) break;
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                double increment = AttributeUtils.getIncrement(attr.m_22087_());
                PlayerStats.LOGGER.info("Configurando atributo: {} Incremento: {}", (Object)attr.m_22087_(), (Object)increment);
            }
            if (!FMLEnvironment.production) {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), btn -> this.sendAttributeChange(attr)).m_252987_(this.leftPos + 10, y, 12, 12).m_253136_());
                plusButtonPos = this.leftPos + 26;
            } else {
                plusButtonPos = this.leftPos + 10;
            }
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> this.sendAttributeChange(attr)).m_252987_(plusButtonPos, y, 12, 12).m_253136_());
            y += 15;
        }
        this.m_142416_((GuiEventListener)this.resetButton);
    }

    private void sendAttributeChange(Attribute attribute) {
        ResourceLocation id = BuiltInRegistries.f_256951_.m_7981_((Object)attribute);
        if (id != null) {
            PacketHandler.sendToServer(new ModifyAttributePacket(id.toString()));
        } else {
            System.out.println("Atributo sem ResourceLocation v\u00e1lido!");
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int upgradeCount;
        int xpCost;
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.m_280218_(BACKGROUND, this.leftPos, this.topPos, 0, 0, 255, 255);
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.searchBox.m_94155_().isEmpty() && !this.searchBox.m_93696_()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.playerstats.search_placeholder"), this.searchBox.m_252754_() + 4, this.searchBox.m_252907_() + 3, 0xA0A0A0, false);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Font font = Minecraft.m_91087_().f_91062_;
        if (player == null) {
            return;
        }
        int points = ClientAttributeCache.getPoints();
        int color = points > 0 ? 65280 : 0xFF5555;
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"gui.playerstats.points", (Object[])new Object[]{points}), this.leftPos + 10, this.topPos + 12, color);
        List<Attribute> filteredAttributes = BuiltInRegistries.f_256951_.m_123024_().filter(arg_0 -> this.lambda$render$5((Player)player, arg_0)).toList();
        int y = this.clipTop - this.scrollOffset + 2;
        for (Attribute attr : filteredAttributes) {
            AttributeInstance instance = player.m_21204_().m_22146_(attr);
            String name = AttributeUtils.getAttributeName(attr);
            if (y + 12 < this.clipTop) {
                y += 15;
                continue;
            }
            String value = String.format("%.2f", instance.m_22135_());
            int pos = FMLEnvironment.production ? this.leftPos + 29 : this.leftPos + 45;
            guiGraphics.m_280056_(font, name + ": " + value, pos, y, 0x303030, false);
            if ((y += 15) <= this.clipBottom) continue;
            break;
        }
        if (this.resetButton != null && this.resetButton.m_274382_()) {
            boolean hasXp = player.f_36078_ >= 50;
            MutableComponent text = hasXp ? Component.m_237115_((String)"gui.playerstats.can_reset") : Component.m_237115_((String)"gui.playerstats.cant_reset");
            color = hasXp ? 65280 : 0xFF5555;
            guiGraphics.m_280614_(font, (Component)text, mouseX + 10, mouseY, color, false);
        }
        boolean hasXpForUpgrade = player.f_36078_ > (xpCost = ((upgradeCount = ClientAttributeCache.getUpgradeCount()) + 1) * 5);
        color = hasXpForUpgrade ? 65280 : 0xFF5555;
        guiGraphics.m_280430_(font, (Component)Component.m_237110_((String)"gui.playerstats.xp_cost", (Object[])new Object[]{xpCost}), this.leftPos + 10, this.topPos + 24, color);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollOffset = (int)((double)this.scrollOffset - delta * 10.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        this.rebuildButtons();
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && this.searchBox.m_5953_(mouseX, mouseY)) {
            this.searchBox.m_94144_("");
            this.scrollOffset = 0;
            this.rebuildButtons();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    private /* synthetic */ boolean lambda$render$5(Player player, Attribute attr) {
        AttributeInstance instance = player.m_21204_().m_22146_(attr);
        if (instance == null || !instance.m_22099_().m_22086_()) {
            return false;
        }
        if (Config.cachedIgnoredAttributes.contains(attr.m_22087_())) {
            return false;
        }
        if (!this.searchText.isEmpty()) {
            String name = AttributeUtils.getAttributeName(attr).toLowerCase();
            return name.contains(this.searchText);
        }
        return true;
    }

    private /* synthetic */ boolean lambda$rebuildButtons$2(Player player, Attribute attr) {
        AttributeInstance attribute = player.m_21204_().m_22146_(attr);
        if (attribute == null || !attribute.m_22099_().m_22086_()) {
            return false;
        }
        if (Config.cachedIgnoredAttributes.contains(attr.m_22087_())) {
            return false;
        }
        if (!this.searchText.isEmpty()) {
            String name = AttributeUtils.getAttributeName(attr).toLowerCase();
            return name.contains(this.searchText);
        }
        return true;
    }
}

