/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.playerstats.Config;
import com.playerstats.ModAttributes;
import com.playerstats.client.KeyBindings;
import com.playerstats.command.PlayerStatsCommands;
import com.playerstats.event.PlayerAttributePersistence;
import com.playerstats.items.AttributeBoostScrollItem;
import com.playerstats.items.ModItems;
import com.playerstats.network.PacketHandler;
import com.playerstats.util.ModDataComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="playerstats")
public class PlayerStats {
    public static final String MODID = "playerstats";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PlayerStats(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        ModItems.register(modEventBus);
        ModDataComponents.register(modEventBus);
        PacketHandler.register(modEventBus);
        PlayerAttributePersistence.register();
        NeoForge.EVENT_BUS.register(AttributeBoostScrollItem.class);
        NeoForge.EVENT_BUS.register((Object)this);
        ModAttributes.ATTRIBUTES.register(modEventBus);
        modEventBus.addListener(ModAttributes::onEntityAttributeModification);
        modEventBus.addListener(this::onConfigReload);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::onClientSetup);
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        PlayerStatsCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        KeyBindings.register();
    }

    private void onConfigReload(ModConfigEvent event) {
        if (event.getConfig().getSpec() == Config.SERVER) {
            Config.reloadCustomMobChances();
        }
    }

    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if (name != null && name.getNamespace().equals("minecraft") && name.getPath().startsWith("chests/")) {
            boolean isTargetChest;
            LootPool pool1 = LootPool.lootPool().name("upgrade_or_crystal_pool").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.UPGRADE_RUNE.get())).when(LootItemRandomChanceCondition.randomChance((float)0.07f))).setWeight(1).setQuality(1)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ABILITY_CRYSTAL.get())).when(LootItemRandomChanceCondition.randomChance((float)0.05f))).setWeight(1).setQuality(1)).build();
            LootPool pool2 = LootPool.lootPool().name("attribute_boost_scroll_pool").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ATTRIBUTE_BOOST_SCROLL.get())).when(LootItemRandomChanceCondition.randomChance((float)0.12f))).setWeight(1).setQuality(1)).build();
            event.getTable().addPool(pool1);
            event.getTable().addPool(pool2);
            boolean bl = isTargetChest = name.getPath().equals("chests/end_city_treasure") || name.getPath().startsWith("chests/bastion_") || name.getPath().equals("chests/ancient_city") || name.getPath().equals("chests/ancient_city_ice_box");
            if (isTargetChest) {
                LootPool pool3 = LootPool.lootPool().name("soul_stone_pool").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SOUL_STONE.get())).when(LootItemRandomChanceCondition.randomChance((float)0.08f))).setWeight(1).setQuality(1)).build();
                event.getTable().addPool(pool3);
            }
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)ModItems.UPGRADE_RUNE.get());
            event.accept((ItemLike)ModItems.ATTRIBUTE_BOOST_SCROLL.get());
            event.accept((ItemLike)ModItems.ABILITY_CRYSTAL.get());
            event.accept((ItemLike)ModItems.SOUL_FRAGMENT.get());
            event.accept((ItemLike)ModItems.SOUL_STONE.get());
        }
    }
}

