/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.client.ClientAttributeCache;
import com.playerstats.client.ClientBoostCache;
import com.playerstats.client.widget.CustomButton;
import com.playerstats.client.widget.CustomSearchBox;
import com.playerstats.network.ModifyAttributePacket;
import com.playerstats.network.PacketHandler;
import com.playerstats.network.ResetAttributesPacket;
import com.playerstats.util.AttributeUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

public class StatsScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)"textures/gui/stats_background.png");
    private static final ResourceLocation PLUS_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)"textures/gui/plus_button.png");
    private static final int BG_WIDTH = 300;
    private static final int BG_HEIGHT = 300;
    private static final int SCROLL_STEP = 17;
    private static final int LINE_HEIGHT = 17;
    private int leftPos;
    private int topPos;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int clipTop;
    private int clipBottom;
    private Button resetButton;
    private Button attributesButton;
    private Button uniqueAbilitiesButton;
    private EditBox searchBox;
    private String searchText = "";
    private LivingEntity entity;
    private Player player;
    private final boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
    private final int requiredXpforReset = (Integer)Config.REQUIRED_XP_FOR_RESET.get();
    private final int xpIncrement = (Integer)Config.XP_COST_INCREMENT.get();
    private boolean showAttributes = true;

    public StatsScreen() {
        super((Component)Component.literal((String)"Player Stats"));
    }

    public StatsScreen(LivingEntity entity) {
        super((Component)Component.literal((String)"Player Stats"));
        this.entity = entity;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 300) / 2;
        this.topPos = (this.height - 300) / 2;
        this.clipTop = this.topPos + 115;
        this.clipBottom = this.topPos + 300 - 60;
        this.player = Minecraft.getInstance().player;
        if (this.entity == null) {
            this.entity = this.player;
        }
        this.searchBox = new CustomSearchBox(this.font, this.leftPos + 25, this.topPos + 95, 260, 19);
        this.searchBox.setResponder(text -> {
            this.searchText = text.toLowerCase();
            this.scrollOffset = 0;
            this.rebuildButtons();
        });
        this.attributesButton = new CustomButton(this.leftPos + 75 - 25, this.topPos + 65, 70, 20, Component.literal((String)"Attributes"), ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)"textures/gui/reset_button.png"), btn -> {
            this.showAttributes = true;
            this.rebuildButtons();
        });
        this.uniqueAbilitiesButton = new CustomButton(this.leftPos + 150 + 25, this.topPos + 65, 85, 20, Component.literal((String)"Unique Abilities"), ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)"textures/gui/reset_button.png"), btn -> {
            this.showAttributes = false;
            this.rebuildButtons();
        });
        this.resetButton = new CustomButton(this.leftPos + 150 - 35, this.topPos + 300 - 50, 70, 20, Component.translatable((String)"gui.playerstats.reset"), ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)"textures/gui/reset_button.png"), btn -> PacketHandler.sendToServer(new ResetAttributesPacket(this.entity.getId())));
        this.rebuildButtons();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderMenuBackground(guiGraphics);
        NeoForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, guiGraphics));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        block12: {
            int textX;
            int textWidth;
            block11: {
                this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
                guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, 300, 300, 300, 300);
                super.render(guiGraphics, mouseX, mouseY, partialTicks);
                this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
                String displayName = this.entity.getDisplayName().getString();
                textWidth = this.font.width(displayName);
                textX = this.leftPos + (300 - textWidth) / 2;
                guiGraphics.drawString(this.font, displayName, textX, this.topPos + 24, 0xA0A0A0, false);
                if (!this.showAttributes) break block11;
                int points = ClientAttributeCache.getPoints();
                int color = points > 0 ? 52326 : 0xFF5555;
                MutableComponent attributepoints = Component.translatable((String)"gui.playerstats.points", (Object[])new Object[]{points});
                textWidth = this.font.width((FormattedText)attributepoints);
                textX = this.leftPos + (300 - textWidth) / 2;
                guiGraphics.drawString(this.font, (Component)attributepoints, textX, this.topPos + 35, color);
                if (this.consumeXp) {
                    int upgradeCount = ClientAttributeCache.getUpgradeCount();
                    int xpCost = (upgradeCount + 1) * this.xpIncrement;
                    boolean hasXpForUpgrade = this.player.experienceLevel > xpCost;
                    color = hasXpForUpgrade ? 52326 : 0xFF5555;
                    MutableComponent xp = Component.translatable((String)"gui.playerstats.xp_cost", (Object[])new Object[]{xpCost});
                    textWidth = this.font.width((FormattedText)xp);
                    textX = this.leftPos + (300 - textWidth) / 2;
                    guiGraphics.drawString(this.font, (Component)xp, textX, this.topPos + 46, color);
                }
                List<Attribute> filteredAttributes = AttributeUtils.getAttributes(this.entity, this.searchText);
                int y = this.clipTop - this.scrollOffset + 2;
                for (Attribute attr : filteredAttributes) {
                    AttributeInstance instance = AttributeUtils.getAttributeInstance(this.entity, attr);
                    String name = AttributeUtils.getAttributeName(attr);
                    if (y + 15 <= this.clipTop) {
                        y += 17;
                        continue;
                    }
                    String value = String.format("%.2f", instance.getValue());
                    int pos = this.leftPos + 40;
                    String baseText = name + ": " + value;
                    guiGraphics.drawString(this.font, baseText, pos, y, 2694419, false);
                    ClientBoostCache.BoostInfo boost = ClientBoostCache.activeBoosts.get(attr);
                    if (boost != null) {
                        String boostText = String.format(" (+%.2f %ds)", boost.amount, boost.secondsRemaining);
                        int boostX = pos + this.font.width(baseText);
                        guiGraphics.drawString(this.font, boostText, boostX, y, 52326, false);
                    }
                    if ((y += 17) < this.clipBottom) continue;
                    break;
                }
                if (this.resetButton == null || !this.resetButton.isHovered()) break block12;
                boolean hasXp = this.player.experienceLevel >= this.requiredXpforReset && this.consumeXp;
                MutableComponent text = hasXp ? Component.translatable((String)"gui.playerstats.can_reset", (Object[])new Object[]{this.requiredXpforReset}).withStyle(s -> s.withColor(65280)) : Component.translatable((String)"gui.playerstats.cant_reset", (Object[])new Object[]{this.requiredXpforReset}).withStyle(s -> s.withColor(0xFF5555));
                guiGraphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
                break block12;
            }
            int points = ClientAttributeCache.getAbilityPoints();
            int color = points > 0 ? 52326 : 0xFF5555;
            MutableComponent abilityPoints = Component.translatable((String)"gui.playerstats.points", (Object[])new Object[]{points});
            textWidth = this.font.width((FormattedText)abilityPoints);
            textX = this.leftPos + (300 - textWidth) / 2;
            guiGraphics.drawString(this.font, (Component)abilityPoints, textX, this.topPos + 35, color);
            if (this.consumeXp) {
                int xpCost = (Integer)Config.REQUIRED_XP_FOR_ABILITY.get();
                boolean hasXpForUpgrade = this.player.experienceLevel > xpCost;
                color = hasXpForUpgrade ? 52326 : 0xFF5555;
                MutableComponent xp = Component.translatable((String)"gui.playerstats.xp_cost", (Object[])new Object[]{xpCost});
                textWidth = this.font.width((FormattedText)xp);
                textX = this.leftPos + (300 - textWidth) / 2;
                guiGraphics.drawString(this.font, (Component)xp, textX, this.topPos + 46, color);
            }
            List<AttributeInstance> filteredAbilities = AttributeUtils.getCustomAttributes(this.entity, this.searchText);
            int y = this.clipTop - this.scrollOffset + 3;
            for (AttributeInstance instance : filteredAbilities) {
                String name = AttributeUtils.getAttributeName((Attribute)instance.getAttribute().value());
                if (y + 15 <= this.clipTop) {
                    y += 17;
                    continue;
                }
                int pos = this.leftPos + 40;
                if (instance.getValue() == -1.0) {
                    guiGraphics.drawString(this.font, name, pos, y, 2694419, false);
                } else if (instance.getValue() == 1.0) {
                    guiGraphics.drawString(this.font, (Component)Component.literal((String)name).append((Component)Component.translatable((String)"gui.playerstats.obtained_active")), pos, y, 2694419, false);
                } else {
                    guiGraphics.drawString(this.font, (Component)Component.literal((String)name).append((Component)Component.translatable((String)"gui.playerstats.obtained_inactive")), pos, y, 2694419, false);
                }
                if ((y += 17) < this.clipBottom) continue;
                break;
            }
        }
    }

    private void rebuildButtons() {
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)this.attributesButton);
        this.addRenderableWidget((GuiEventListener)this.uniqueAbilitiesButton);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        if (this.showAttributes) {
            List<Attribute> filteredAttributes = AttributeUtils.getAttributes(this.entity, this.searchText);
            int visibleLines = (this.clipBottom - this.clipTop) / 17;
            this.maxScroll = Math.max(0, (filteredAttributes.size() - visibleLines) * 17);
            int y = this.clipTop - this.scrollOffset;
            for (Attribute attr : filteredAttributes) {
                if (y + 17 <= this.clipTop) {
                    y += 17;
                    continue;
                }
                if (y + 4 >= this.clipBottom) break;
                if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                    double increment = AttributeUtils.getIncrement(attr.getDescriptionId());
                    PlayerStats.LOGGER.info("Configurando atributo: {} Incremento: {}", (Object)attr.getDescriptionId(), (Object)increment);
                }
                this.addRenderableWidget((GuiEventListener)new CustomButton(this.leftPos + 20, y, 14, 14, Component.empty(), PLUS_BUTTON_TEXTURE, button -> this.sendAttributeChange(attr)));
                y += 17;
            }
            this.addRenderableWidget((GuiEventListener)this.resetButton);
        } else {
            List<AttributeInstance> filteredAbilities = AttributeUtils.getCustomAttributes(this.entity, this.searchText);
            int visibleLines = (this.clipBottom - this.clipTop) / 17;
            this.maxScroll = Math.max(0, (filteredAbilities.size() - visibleLines) * 17);
            int y = this.clipTop - this.scrollOffset;
            for (AttributeInstance instance : filteredAbilities) {
                if (y + 17 <= this.clipTop) {
                    y += 17;
                    continue;
                }
                if (y + 4 >= this.clipBottom) break;
                this.addRenderableWidget((GuiEventListener)new CustomButton(this.leftPos + 20, y, 14, 14, Component.empty(), PLUS_BUTTON_TEXTURE, button -> this.sendAttributeChange((Attribute)instance.getAttribute().value())));
                y += 17;
            }
        }
    }

    private void sendAttributeChange(Attribute attribute) {
        ResourceLocation id = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
        if (id != null) {
            PacketHandler.sendToServer(new ModifyAttributePacket(this.entity.getId(), id.toString()));
        } else {
            System.out.println("Atributo sem ResourceLocation v\u00e1lido!");
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scrollOffset = (int)((double)this.scrollOffset - scrollY * 17.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        this.rebuildButtons();
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && this.searchBox.isMouseOver(mouseX, mouseY)) {
            this.searchBox.setValue("");
            this.scrollOffset = 0;
            this.rebuildButtons();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

