/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.entities.goals;

import com.playerstats.ModAttributes;
import com.playerstats.util.AttributeUtils;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;

public class DefendOwnerTargetGoal
extends TargetGoal {
    private final IronGolem golem;
    private Player owner;

    public DefendOwnerTargetGoal(IronGolem golem) {
        super((Mob)golem, false);
        this.golem = golem;
    }

    public boolean canUse() {
        UUID ownerId = null;
        if (this.golem.getPersistentData().contains("Owner")) {
            ownerId = this.golem.getPersistentData().getUUID("Owner");
        }
        if (ownerId == null) {
            return false;
        }
        if (AttributeUtils.getAttributeValue((LivingEntity)this.golem, ModAttributes.DEFEND_OWNER) < 1.0) {
            return false;
        }
        this.owner = this.golem.level().getPlayerByUUID(ownerId);
        if (this.owner == null) {
            return false;
        }
        LivingEntity attacker = this.owner.getLastHurtByMob();
        if (attacker != null && attacker.isAlive()) {
            this.targetMob = attacker;
            return true;
        }
        return false;
    }
}

