/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import com.playerstats.entities.goals.DefendOwnerTargetGoal;
import com.playerstats.entities.goals.FollowOwnerGoal;
import com.playerstats.items.ModItems;
import com.playerstats.util.ModDataComponents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="playerstats")
public class ModAbilityEvents {
    private static final Map<UUID, Long> howlCooldowns = new HashMap<UUID, Long>();
    private static final long HOWL_COOLDOWN_TICKS = 6000L;

    @SubscribeEvent
    public static void onHorseTamed(AnimalTameEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)livingEntity;
            horse.getPersistentData().putUUID("Owner", event.getTamer().getUUID());
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal((Mob)horse));
        }
        if ((entity = event.getEntity()) instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            golem.targetSelector.addGoal(1, (Goal)new DefendOwnerTargetGoal(golem));
            golem.targetSelector.addGoal(3, (Goal)new FollowOwnerGoal((Mob)golem));
        }
    }

    @SubscribeEvent
    public static void onHorseTick(PlayerTickEvent.Post event) {
        Entity entity = event.getEntity().getVehicle();
        if (!(entity instanceof AbstractHorse)) {
            return;
        }
        AbstractHorse horse = (AbstractHorse)entity;
        Level level = horse.level();
        if (level.isClientSide) {
            return;
        }
        boolean hasFrostWalker = Optional.ofNullable(horse.getAttribute(ModAttributes.FROST_WALKER.getDelegate())).map(attr -> attr.getValue() == 1.0).orElse(false);
        if (hasFrostWalker) {
            ModAbilityEvents.applyFrostWalker((Entity)horse, horse.level(), horse.blockPosition(), 1);
        }
    }

    @SubscribeEvent
    public static void onMobDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        AttributeInstance revivable = entity.getAttribute(ModAttributes.REBIRTH.getDelegate());
        if (revivable != null && revivable.getValue() == 1.0) {
            ItemStack soulFragment = new ItemStack((ItemLike)ModItems.SOUL_FRAGMENT.get());
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                CompoundTag soulData = new CompoundTag();
                player.saveWithoutId(soulData);
                soulData.putString("id", "minecraft:player");
                soulData.putString("UUID", player.getUUID().toString());
                soulFragment.set(ModDataComponents.STORED_ENTITY, (Object)soulData);
            } else {
                CompoundTag soulData = new CompoundTag();
                entity.save(soulData);
                soulData.putString("StoredEntityName", entity.getDisplayName().getString());
                soulFragment.set(ModDataComponents.STORED_ENTITY, (Object)soulData);
            }
            ItemEntity drop = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), soulFragment);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public static void onTargetChange(LivingChangeTargetEvent event) {
        List wolves;
        LivingEntity attacker = event.getEntity();
        LivingEntity originalTarget = event.getOriginalAboutToBeSetTarget();
        if (!(originalTarget instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)originalTarget;
        Level level = attacker.level();
        List golems = level.getEntitiesOfClass(IronGolem.class, attacker.getBoundingBox().inflate(16.0), g -> g.getAttribute(ModAttributes.TAUNT.getDelegate()) != null && g.getAttribute(ModAttributes.TAUNT.getDelegate()).getValue() == 1.0 && g.isAlive());
        if (!golems.isEmpty()) {
            IronGolem golem = (IronGolem)golems.get(0);
            event.setNewAboutToBeSetTarget((LivingEntity)golem);
            golem.setTarget(attacker);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, golem.getX(), golem.getY() + 1.0, golem.getZ(), 10, 0.5, 0.5, 0.5, 0.05);
            }
        }
        if (!(wolves = level.getEntitiesOfClass(LivingEntity.class, attacker.getBoundingBox().inflate(16.0), w -> w.isAlive() && w.getType() == EntityType.WOLF && w.getAttribute(ModAttributes.TAUNT.getDelegate()) != null && w.getAttribute(ModAttributes.TAUNT.getDelegate()).getValue() == 1.0)).isEmpty()) {
            Wolf wolf = (Wolf)wolves.get(0);
            event.setNewAboutToBeSetTarget((LivingEntity)wolf);
            wolf.setTarget(attacker);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, wolf.getX(), wolf.getY() + 0.5, wolf.getZ(), 10, 0.3, 0.3, 0.3, 0.05);
            }
        }
    }

    @SubscribeEvent
    public static void onWolfTargetChange(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)livingEntity;
        if (event.getNewAboutToBeSetTarget() == null) {
            return;
        }
        long lastHowl = howlCooldowns.getOrDefault(wolf.getUUID(), 0L);
        if (wolf.level().getGameTime() - lastHowl < 6000L) {
            return;
        }
        if (wolf.getAttribute(ModAttributes.HOWL_BUFF.getDelegate()).getValue() != 1.0) {
            return;
        }
        howlCooldowns.put(wolf.getUUID(), wolf.level().getGameTime());
        double howlRadius = 8.0;
        List allies = wolf.level().getEntitiesOfClass(Wolf.class, wolf.getBoundingBox().inflate(howlRadius), w -> w.isAlive() && w != wolf);
        for (Wolf ally : allies) {
            ally.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1));
            ally.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
            ally.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 1));
        }
        Player owner = (Player)wolf.getOwner();
        owner.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1));
        owner.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
        owner.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 1));
        wolf.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1));
        wolf.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
        wolf.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 1));
        Level level = wolf.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)ParticleTypes.SOUL, wolf.getX(), wolf.getY() + 1.0, wolf.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
        }
        wolf.playSound(SoundEvents.WOLF_HOWL, 1.0f, 1.0f);
    }

    public static void applyFrostWalker(Entity entity, Level level, BlockPos pos, int levelFrost) {
        if (!entity.onGround()) {
            return;
        }
        BlockState frostedIce = Blocks.FROSTED_ICE.defaultBlockState();
        float radius = Math.min(16, 2 + levelFrost);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset((int)(-radius), -1, (int)(-radius)), (BlockPos)pos.offset((int)radius, -1, (int)radius))) {
            BlockState state;
            if (!blockpos.closerToCenterThan((Position)entity.position(), (double)radius)) continue;
            mutable.set(blockpos.getX(), blockpos.getY() + 1, blockpos.getZ());
            if (!level.getBlockState((BlockPos)mutable).isAir() || (state = level.getBlockState(blockpos)).getBlock() != Blocks.WATER || (Integer)state.getValue((Property)LiquidBlock.LEVEL) != 0 || !frostedIce.canSurvive((LevelReader)level, blockpos) || !level.isUnobstructed(frostedIce, blockpos, CollisionContext.empty())) continue;
            level.setBlockAndUpdate(blockpos, frostedIce);
            level.scheduleTick(blockpos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)entity.getRandom(), (int)60, (int)120));
        }
    }
}

