/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.items.ModItems;
import com.playerstats.util.ModDataComponents;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="playerstats")
public class SoulReviveHandler {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (++tickCounter % 40 != 0) {
            return;
        }
        for (Player player : level.players()) {
            BlockPos pPos = player.blockPosition();
            AABB box = new AABB((double)(pPos.getX() - 8), (double)(pPos.getY() - 4), (double)(pPos.getZ() - 8), (double)(pPos.getX() + 8), (double)(pPos.getY() + 4), (double)(pPos.getZ() + 8));
            List items = level.getEntitiesOfClass(ItemEntity.class, box);
            HashMap<BlockPos, ItemEntity> stones = new HashMap<BlockPos, ItemEntity>();
            for (ItemEntity ie : items) {
                ItemStack stack = ie.getItem();
                if (stack == null || stack.getItem() != ModItems.SOUL_STONE.get()) continue;
                stones.put(ie.blockPosition(), ie);
            }
            if (stones.isEmpty()) {
                return;
            }
            for (ItemEntity fragmentEntity : items) {
                List candidates;
                String entityId;
                CompoundTag storedEntityTag;
                ItemStack fragStack = fragmentEntity.getItem();
                if (fragStack.getItem() != ModItems.SOUL_FRAGMENT.get()) continue;
                BlockPos pos = fragmentEntity.blockPosition();
                BlockState state = level.getBlockState(pos.below());
                if (state.is(Blocks.RESPAWN_ANCHOR) && (Integer)state.getValue((Property)RespawnAnchorBlock.CHARGE) <= 0) {
                    return;
                }
                ItemEntity stoneEntity = (ItemEntity)stones.get(pos);
                if (stoneEntity == null || (storedEntityTag = (CompoundTag)fragStack.get(ModDataComponents.STORED_ENTITY)) == null || !storedEntityTag.contains("id") || (entityId = storedEntityTag.getString("id")).isEmpty() || (candidates = entityId.equals("minecraft:player") ? level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.5), e -> e.getType() == EntityType.VILLAGER) : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.5), e -> {
                    ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType());
                    return key != null && entityId.equals(key.toString());
                })).isEmpty()) continue;
                LivingEntity sacrifice = (LivingEntity)candidates.get(0);
                ServerLevel server = (ServerLevel)level;
                Entity created = null;
                if (entityId.equals("minecraft:player")) {
                    String uuidStr = storedEntityTag.getString("UUID");
                    if (uuidStr != null && !uuidStr.isEmpty()) {
                        UUID uuid = UUID.fromString(uuidStr);
                        ServerPlayer revivedPlayer = server.getServer().getPlayerList().getPlayer(uuid);
                        if (revivedPlayer == null || revivedPlayer.gameMode.getGameModeForPlayer() != GameType.SPECTATOR) {
                            continue;
                        }
                    }
                } else {
                    ResourceLocation id = ResourceLocation.tryParse((String)entityId);
                    EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
                    created = type.create(level);
                }
                server.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 40, 0.5, 0.5, 0.5, 0.05);
                LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                if (lightning != null) {
                    lightning.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                    lightning.setVisualOnly(true);
                    level.addFreshEntity((Entity)lightning);
                }
                level.explode(null, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 2.0f, Level.ExplosionInteraction.BLOCK);
                if (created instanceof ServerPlayer) {
                    ServerPlayer revivedPlayer = (ServerPlayer)created;
                    revivedPlayer.load(storedEntityTag);
                    revivedPlayer.getFoodData().setFoodLevel(3);
                    revivedPlayer.getFoodData().setSaturation(0.0f);
                    revivedPlayer.setGameMode(GameType.SURVIVAL);
                    revivedPlayer.teleportTo(server, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, level.random.nextFloat() * 360.0f, 0.0f);
                    int duration = 12000;
                    revivedPlayer.addEffect(new MobEffectInstance(MobEffects.HUNGER, duration, 1));
                    revivedPlayer.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration, 1));
                    revivedPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 1));
                    revivedPlayer.setHealth(1.0f);
                    revivedPlayer.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
                }
                if (created instanceof LivingEntity) {
                    LivingEntity revived = (LivingEntity)created;
                    revived.load(storedEntityTag);
                    revived.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, level.random.nextFloat() * 360.0f, 0.0f);
                    revived.setHealth(1.0f);
                    level.addFreshEntity((Entity)revived);
                    revived.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
                }
                fragmentEntity.discard();
                stoneEntity.discard();
                sacrifice.kill();
                level.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.setHealth(1.0f);
                serverPlayer.getFoodData().setFoodLevel(0);
                serverPlayer.getFoodData().setSaturation(0.0f);
                int duration = 12000;
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.HUNGER, duration, 1));
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration, 1));
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 1));
            }
        }
    }
}

