/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.items;

import com.playerstats.Config;
import com.playerstats.network.BoostsSyncPacket;
import com.playerstats.network.PacketHandler;
import com.playerstats.util.AttributeUtils;
import com.playerstats.util.ModDataComponents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class AttributeBoostScrollItem
extends Item {
    public static final Map<UUID, List<BoostInstance>> activeBoosts = new HashMap<UUID, List<BoostInstance>>();

    public AttributeBoostScrollItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            Random random = new Random();
            if (stack.get(ModDataComponents.DEFINED_ATTRIBUTE) == null) {
                List<Attribute> filteredAttributes = AttributeUtils.getAttributes((LivingEntity)player, "");
                if (!filteredAttributes.isEmpty()) {
                    Attribute selected = filteredAttributes.get(random.nextInt(filteredAttributes.size()));
                    stack.set(ModDataComponents.DEFINED_ATTRIBUTE, (Object)BuiltInRegistries.ATTRIBUTE.getKey((Object)selected).toString());
                    int minMultiplier = (Integer)Config.BOOST_AMOUNT_MIN_MULTIPLIER.get();
                    int maxMultiplier = (Integer)Config.BOOST_AMOUNT_MAX_MULTIPLIER.get();
                    double baseIncrement = AttributeUtils.getIncrement(selected.getDescriptionId());
                    int multiplier = minMultiplier + random.nextInt(maxMultiplier - minMultiplier + 1);
                    double amount = baseIncrement * (double)multiplier;
                    int minMinutes = (Integer)Config.BOOST_DURATION_MIN_MINUTES.get();
                    int maxMinutes = (Integer)Config.BOOST_DURATION_MAX_MINUTES.get();
                    int minTicks = minMinutes * 60 * 20;
                    int maxTicks = maxMinutes * 60 * 20;
                    int duration = minTicks + random.nextInt(maxTicks - minTicks + 1);
                    stack.set(ModDataComponents.BOOST_AMOUNT, (Object)amount);
                    stack.set(ModDataComponents.BOOST_DURATION, (Object)duration);
                }
            } else {
                String attrKey = (String)stack.get(ModDataComponents.DEFINED_ATTRIBUTE);
                Attribute attribute = BuiltInRegistries.ATTRIBUTE.getOptional(ResourceLocation.tryParse((String)attrKey)).orElse(null);
                if (attribute != null) {
                    ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)attribute.getDescriptionId());
                    double amount = (Double)stack.get(ModDataComponents.BOOST_AMOUNT);
                    int duration = (Integer)stack.get(ModDataComponents.BOOST_DURATION);
                    this.applyBoost(player, attribute, modifierId, amount, duration);
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private void applyBoost(Player player, Attribute attribute, ResourceLocation id, double amount, int duration) {
        AttributeInstance instance = AttributeUtils.getAttributeInstance((LivingEntity)player, attribute);
        if (instance == null) {
            return;
        }
        UUID playerId = player.getUUID();
        List boosts = activeBoosts.computeIfAbsent(playerId, k -> new ArrayList());
        for (BoostInstance existing : boosts) {
            if (!existing.attribute.equals(attribute)) continue;
            existing.ticksRemaining = duration;
            existing.amount = amount;
            AttributeBoostScrollItem.sendBoostsToClient(player);
            return;
        }
        ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"playerstats_scroll_boost", (String)attribute.getDescriptionId());
        instance.removeModifier(modifierId);
        AttributeModifier modifier = new AttributeModifier(modifierId, amount, AttributeModifier.Operation.ADD_VALUE);
        instance.addTransientModifier(modifier);
        boosts.add(new BoostInstance(attribute, id, duration, amount));
        AttributeBoostScrollItem.sendBoostsToClient(player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (stack.get(ModDataComponents.DEFINED_ATTRIBUTE) != null) {
            Attribute attribute = BuiltInRegistries.ATTRIBUTE.getOptional(ResourceLocation.tryParse((String)((String)stack.get(ModDataComponents.DEFINED_ATTRIBUTE)))).orElse(null);
            if (attribute != null) {
                double amount = (Double)stack.get(ModDataComponents.BOOST_AMOUNT);
                int durationSec = (Integer)stack.get(ModDataComponents.BOOST_DURATION) / 20;
                tooltip.add((Component)Component.translatable((String)"item.playerstats.attribute_boost_scroll.hover_text_unveiled", (Object[])new Object[]{AttributeUtils.getAttributeName(attribute)}).withStyle(ChatFormatting.AQUA));
                tooltip.add((Component)Component.translatable((String)"item.playerstats.attribute_boost_scroll.hover_text_values", (Object[])new Object[]{amount, durationSec}).withStyle(ChatFormatting.GREEN));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"item.playerstats.attribute_boost_scroll.hover_text").withStyle(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        UUID playerId = event.getEntity().getUUID();
        List<BoostInstance> boosts = activeBoosts.get(playerId);
        if (boosts == null || boosts.isEmpty()) {
            return;
        }
        Iterator<BoostInstance> iterator = boosts.iterator();
        while (iterator.hasNext()) {
            BoostInstance boost = iterator.next();
            --boost.ticksRemaining;
            if (boost.ticksRemaining > 0) continue;
            AttributeInstance instance = AttributeUtils.getAttributeInstance((LivingEntity)event.getEntity(), boost.attribute);
            if (instance != null) {
                instance.removeModifier(boost.modifierId);
            }
            iterator.remove();
            AttributeBoostScrollItem.sendBoostsToClient(event.getEntity());
        }
        if (boosts.isEmpty()) {
            activeBoosts.remove(playerId);
        } else {
            AttributeBoostScrollItem.sendBoostsToClient(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AttributeBoostScrollItem.saveBoostsToPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        AttributeBoostScrollItem.loadBoostsFromPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        player.getPersistentData().remove("PlayerStatsBoosts");
        activeBoosts.remove(player.getUUID());
        AttributeBoostScrollItem.sendBoostsToClient((Player)player);
    }

    public static void sendBoostsToClient(Player player) {
        UUID playerId = player.getUUID();
        List<BoostInstance> boosts = activeBoosts.get(playerId);
        if (boosts == null || boosts.isEmpty()) {
            return;
        }
        Map<ResourceLocation, BoostsSyncPacket.BoostData> map = boosts.stream().collect(Collectors.toMap(boost -> BuiltInRegistries.ATTRIBUTE.getKey((Object)boost.attribute), boost -> new BoostsSyncPacket.BoostData(boost.amount, boost.ticksRemaining / 20)));
        PacketHandler.sendToClient(new BoostsSyncPacket(map), (ServerPlayer)player);
    }

    public static void saveBoostsToPlayer(Player player) {
        UUID playerId = player.getUUID();
        List<BoostInstance> boosts = activeBoosts.get(playerId);
        if (boosts == null || boosts.isEmpty()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < boosts.size(); ++i) {
            BoostInstance boost = boosts.get(i);
            CompoundTag boostTag = new CompoundTag();
            boostTag.putString("Attribute", BuiltInRegistries.ATTRIBUTE.getKey((Object)boost.attribute).toString());
            boostTag.putString("ModifierId", boost.modifierId.getNamespace());
            boostTag.putInt("TicksRemaining", boost.ticksRemaining);
            boostTag.putDouble("Amount", boost.amount);
            tag.put("Boost" + i, (Tag)boostTag);
        }
        player.getPersistentData().put("PlayerStatsBoosts", (Tag)tag);
        AttributeBoostScrollItem.sendBoostsToClient(player);
    }

    public static void loadBoostsFromPlayer(Player player) {
        CompoundTag tag = player.getPersistentData().getCompound("PlayerStatsBoosts");
        if (tag == null || tag.isEmpty()) {
            return;
        }
        UUID playerId = player.getUUID();
        ArrayList<BoostInstance> boosts = new ArrayList<BoostInstance>();
        for (String key : tag.getAllKeys()) {
            AttributeInstance instance;
            CompoundTag boostTag = tag.getCompound(key);
            String attrKey = boostTag.getString("Attribute");
            String modId = boostTag.getString("ModifierId");
            int ticks = boostTag.getInt("TicksRemaining");
            double amount = boostTag.getDouble("Amount");
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)modId);
            Attribute attribute = BuiltInRegistries.ATTRIBUTE.getOptional(ResourceLocation.tryParse((String)attrKey)).orElse(null);
            if (attribute == null || (instance = AttributeUtils.getAttributeInstance((LivingEntity)player, attribute)) == null) continue;
            ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"playerstats", (String)"scroll_boost");
            instance.addTransientModifier(new AttributeModifier(modifierId, amount, AttributeModifier.Operation.ADD_VALUE));
            boosts.add(new BoostInstance(attribute, id, ticks, amount));
        }
        if (!boosts.isEmpty()) {
            activeBoosts.put(playerId, boosts);
        }
        AttributeBoostScrollItem.sendBoostsToClient(player);
    }

    public static class BoostInstance {
        public final Attribute attribute;
        public final ResourceLocation modifierId;
        public int ticksRemaining;
        public double amount;

        public BoostInstance(Attribute attribute, ResourceLocation modifierId, int ticksRemaining, double amount) {
            this.attribute = attribute;
            this.modifierId = modifierId;
            this.ticksRemaining = ticksRemaining;
            this.amount = amount;
        }
    }
}

