/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.items;

import com.playerstats.Config;
import com.playerstats.network.BoostsSyncPacket;
import com.playerstats.network.PacketHandler;
import com.playerstats.util.AttributeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AttributeBoostScrollItem
extends Item {
    private static final Map<UUID, List<BoostInstance>> activeBoosts = new HashMap<UUID, List<BoostInstance>>();

    public AttributeBoostScrollItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            Random random = new Random();
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("DefinedAttribute")) {
                List<Attribute> filteredAttributes = AttributeUtils.getAttributes(player, "");
                if (!filteredAttributes.isEmpty()) {
                    Attribute selected = filteredAttributes.get(random.nextInt(filteredAttributes.size()));
                    tag.m_128359_("DefinedAttribute", BuiltInRegistries.f_256951_.m_7981_((Object)selected).toString());
                    int minMultiplier = (Integer)Config.BOOST_AMOUNT_MIN_MULTIPLIER.get();
                    int maxMultiplier = (Integer)Config.BOOST_AMOUNT_MAX_MULTIPLIER.get();
                    double baseIncrement = AttributeUtils.getIncrement(selected.m_22087_());
                    int multiplier = minMultiplier + random.nextInt(maxMultiplier - minMultiplier + 1);
                    double amount = baseIncrement * (double)multiplier;
                    int minMinutes = (Integer)Config.BOOST_DURATION_MIN_MINUTES.get();
                    int maxMinutes = (Integer)Config.BOOST_DURATION_MAX_MINUTES.get();
                    int minTicks = minMinutes * 60 * 20;
                    int maxTicks = maxMinutes * 60 * 20;
                    int duration = minTicks + random.nextInt(maxTicks - minTicks + 1);
                    tag.m_128347_("BoostAmount", amount);
                    tag.m_128405_("BoostDuration", duration);
                }
            } else {
                String attrKey = tag.m_128461_("DefinedAttribute");
                Attribute attribute = BuiltInRegistries.f_256951_.m_6612_(new ResourceLocation(attrKey)).orElse(null);
                if (attribute != null) {
                    UUID modifierId = UUID.randomUUID();
                    double amount = tag.m_128459_("BoostAmount");
                    int duration = tag.m_128451_("BoostDuration");
                    this.applyBoost(player, attribute, modifierId, amount, duration);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void applyBoost(Player player, Attribute attribute, UUID id, double amount, int duration) {
        AttributeInstance instance = player.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        UUID playerId = player.m_20148_();
        List boosts = activeBoosts.computeIfAbsent(playerId, k -> new ArrayList());
        for (BoostInstance existing : boosts) {
            if (!existing.attribute.equals(attribute)) continue;
            existing.ticksRemaining = duration;
            existing.amount = amount;
            AttributeBoostScrollItem.sendBoostsToClient(player);
            return;
        }
        instance.m_22120_(id);
        instance.m_22118_(new AttributeModifier(id, "Scroll Boost", amount, AttributeModifier.Operation.ADDITION));
        boosts.add(new BoostInstance(attribute, id, duration, amount));
        AttributeBoostScrollItem.sendBoostsToClient(player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("DefinedAttribute")) {
            Attribute attribute = BuiltInRegistries.f_256951_.m_6612_(new ResourceLocation(tag.m_128461_("DefinedAttribute"))).orElse(null);
            if (attribute != null) {
                double amount = tag.m_128459_("BoostAmount");
                int durationSec = tag.m_128451_("BoostDuration") / 20;
                tooltip.add((Component)Component.m_237110_((String)"item.playerstats.attribute_boost_scroll.hover_text_unveiled", (Object[])new Object[]{AttributeUtils.getAttributeName(attribute)}).m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237110_((String)"item.playerstats.attribute_boost_scroll.hover_text_values", (Object[])new Object[]{amount, durationSec}).m_130940_(ChatFormatting.GREEN));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.playerstats.attribute_boost_scroll.hover_text").m_130940_(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        UUID playerId = event.player.m_20148_();
        List<BoostInstance> boosts = activeBoosts.get(playerId);
        if (boosts == null || boosts.isEmpty()) {
            return;
        }
        Iterator<BoostInstance> iterator = boosts.iterator();
        while (iterator.hasNext()) {
            BoostInstance boost = iterator.next();
            --boost.ticksRemaining;
            if (boost.ticksRemaining > 0) continue;
            AttributeInstance instance = event.player.m_21051_(boost.attribute);
            if (instance != null) {
                instance.m_22120_(boost.modifierId);
            }
            iterator.remove();
            AttributeBoostScrollItem.sendBoostsToClient(event.player);
        }
        if (boosts.isEmpty()) {
            activeBoosts.remove(playerId);
        } else {
            AttributeBoostScrollItem.sendBoostsToClient(event.player);
        }
    }

    public static void saveBoostsToPlayer(Player player) {
        UUID playerId = player.m_20148_();
        List<BoostInstance> boosts = activeBoosts.get(playerId);
        if (boosts == null || boosts.isEmpty()) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        int index = 0;
        for (BoostInstance boost : boosts) {
            CompoundTag boostTag = new CompoundTag();
            boostTag.m_128359_("Attribute", BuiltInRegistries.f_256951_.m_7981_((Object)boost.attribute).toString());
            boostTag.m_128362_("ModifierId", boost.modifierId);
            boostTag.m_128405_("TicksRemaining", boost.ticksRemaining);
            boostTag.m_128347_("Amount", boost.amount);
            tag.m_128365_("Boost" + index, (Tag)boostTag);
            ++index;
        }
        player.getPersistentData().m_128365_("PlayerStatsBoosts", (Tag)tag);
        AttributeBoostScrollItem.sendBoostsToClient(player);
    }

    public static void loadBoostsFromPlayer(Player player) {
        CompoundTag tag = player.getPersistentData().m_128469_("PlayerStatsBoosts");
        if (tag == null || tag.m_128456_()) {
            return;
        }
        UUID playerId = player.m_20148_();
        ArrayList<BoostInstance> boosts = new ArrayList<BoostInstance>();
        for (String key : tag.m_128431_()) {
            CompoundTag boostTag = tag.m_128469_(key);
            String attrKey = boostTag.m_128461_("Attribute");
            UUID modId = boostTag.m_128342_("ModifierId");
            int ticks = boostTag.m_128451_("TicksRemaining");
            Attribute attribute = BuiltInRegistries.f_256951_.m_6612_(new ResourceLocation(attrKey)).orElse(null);
            if (attribute == null) continue;
            double amount = boostTag.m_128459_("Amount");
            AttributeInstance instance = player.m_21051_(attribute);
            if (instance == null) continue;
            instance.m_22118_(new AttributeModifier(modId, "Scroll Boost", amount, AttributeModifier.Operation.ADDITION));
            boosts.add(new BoostInstance(attribute, modId, ticks, amount));
        }
        if (!boosts.isEmpty()) {
            activeBoosts.put(playerId, boosts);
        }
        AttributeBoostScrollItem.sendBoostsToClient(player);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AttributeBoostScrollItem.saveBoostsToPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        AttributeBoostScrollItem.loadBoostsFromPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        CompoundTag data = player.getPersistentData();
        data.m_128473_("PlayerStatsBoosts");
        activeBoosts.remove(player.m_20148_());
        AttributeBoostScrollItem.sendBoostsToClient((Player)player);
    }

    public static void sendBoostsToClient(Player player) {
        UUID playerId = player.m_20148_();
        List<BoostInstance> boosts = activeBoosts.get(playerId);
        if (boosts == null || boosts.isEmpty()) {
            PacketHandler.sendToClient(new BoostsSyncPacket(Map.of()), (ServerPlayer)player);
            return;
        }
        Map<ResourceLocation, BoostsSyncPacket.BoostData> map = boosts.stream().collect(Collectors.toMap(boost -> BuiltInRegistries.f_256951_.m_7981_((Object)boost.attribute), boost -> new BoostsSyncPacket.BoostData(boost.amount, boost.ticksRemaining / 20)));
        PacketHandler.sendToClient(new BoostsSyncPacket(map), (ServerPlayer)player);
    }

    public static class BoostInstance {
        public final Attribute attribute;
        public final UUID modifierId;
        public int ticksRemaining;
        public double amount;

        public BoostInstance(Attribute attribute, UUID modifierId, int ticksRemaining, double amount) {
            this.attribute = attribute;
            this.modifierId = modifierId;
            this.ticksRemaining = ticksRemaining;
            this.amount = amount;
        }
    }
}

