/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.entities.goals;

import com.playerstats.ModAttributes;
import com.playerstats.util.AttributeUtils;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FollowOwnerGoal
extends Goal {
    private final Mob mob;
    private Player owner;
    private final double speed = 1.2;
    private final float minDist = 6.0f;
    private final float maxDist = 15.0f;

    public FollowOwnerGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null && this.mob.getTarget().isAlive()) {
            return false;
        }
        try {
            UUID ownerId = this.mob.getPersistentData().getUUID("Owner");
            if (ownerId == null) {
                return false;
            }
            this.owner = this.mob.level().getPlayerByUUID(ownerId);
            return this.owner != null && !this.mob.isPassenger() && !this.mob.isLeashed() && this.mob.distanceTo((Entity)this.owner) > 6.0f;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null && this.mob.getTarget().isAlive()) {
            return false;
        }
        return this.owner != null && this.mob.distanceTo((Entity)this.owner) > 15.0f && !this.mob.isPassenger() && !this.mob.isLeashed();
    }

    public void tick() {
        if (this.owner == null) {
            return;
        }
        if (AttributeUtils.getAttributeValue((LivingEntity)this.mob, ModAttributes.FOLLOW_OWNER) < 1.0) {
            return;
        }
        double distance = this.mob.distanceTo((Entity)this.owner);
        if (distance > 12.0 && AttributeUtils.getAttributeValue((LivingEntity)this.mob, ModAttributes.TELEPORT_TO_OWNER) == 1.0) {
            this.teleportToOwner();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.owner, 1.2);
        }
    }

    private void teleportToOwner() {
        if (this.owner == null) {
            return;
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dy = 0; dy >= -2; --dy) {
                    Vec3 target = this.owner.position().add((double)dx, (double)dy, (double)dz);
                    BlockPos pos = BlockPos.containing((Position)target);
                    BlockPos below = pos.below();
                    if (!this.mob.level().getBlockState(pos).getCollisionShape((BlockGetter)this.mob.level(), pos).isEmpty() || !this.mob.level().getBlockState(below).isSolidRender((BlockGetter)this.mob.level(), below)) continue;
                    this.mob.setPos(target.x, target.y, target.z);
                    this.mob.getNavigation().stop();
                    return;
                }
            }
        }
    }
}

