/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

@EventBusSubscriber(modid="playerstats")
public class TauntHandler {
    private static final Map<UUID, Long> tauntActiveUntil = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> tauntCooldownUntil = new HashMap<UUID, Long>();
    private static final long DURATION_TICKS = 600L;
    private static final long COOLDOWN_TICKS = 1200L;

    @SubscribeEvent
    public static void onTargetSet(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof IronGolem)) {
            return;
        }
        IronGolem golem = (IronGolem)livingEntity;
        LivingEntity newTarget = event.getNewAboutToBeSetTarget();
        if (newTarget != null && golem.getPersistentData().hasUUID("Owner")) {
            UUID ownerId = golem.getPersistentData().getUUID("Owner");
            if (newTarget.getUUID().equals(ownerId)) {
                event.setNewAboutToBeSetTarget(null);
            }
        }
    }

    @SubscribeEvent
    public static void onTargetChange(LivingChangeTargetEvent event) {
        Wolf wolf;
        LivingEntity attacker = event.getEntity();
        LivingEntity originalTarget = event.getOriginalAboutToBeSetTarget();
        if (!(originalTarget instanceof ServerPlayer)) {
            return;
        }
        Level level = attacker.level();
        if (attacker.getPersistentData().contains("Owner") && originalTarget.getUUID().equals(attacker.getPersistentData().getUUID("Owner"))) {
            event.setCanceled(true);
            return;
        }
        List golems = level.getEntitiesOfClass(IronGolem.class, attacker.getBoundingBox().inflate(16.0), g -> g.isAlive() && g.getAttribute(ModAttributes.TAUNT.getDelegate()) != null && g.getAttribute(ModAttributes.TAUNT.getDelegate()).getValue() == 1.0);
        for (IronGolem golem : golems) {
            if (attacker == golem) continue;
            if (TauntHandler.activateTaunt((LivingEntity)golem)) {
                TauntHandler.triggerTauntParticles((LivingEntity)golem, level);
            }
            if (!TauntHandler.isTauntActive((LivingEntity)golem)) continue;
            event.setNewAboutToBeSetTarget((LivingEntity)golem);
            golem.setTarget(attacker);
            return;
        }
        List wolves = level.getEntitiesOfClass(Wolf.class, attacker.getBoundingBox().inflate(16.0), w -> w.isAlive() && w.getAttribute(ModAttributes.TAUNT.getDelegate()) != null && w.getAttribute(ModAttributes.TAUNT.getDelegate()).getValue() == 1.0);
        Iterator iterator = wolves.iterator();
        while (iterator.hasNext() && attacker != (wolf = (Wolf)iterator.next())) {
            if (TauntHandler.activateTaunt((LivingEntity)wolf)) {
                TauntHandler.triggerTauntParticles((LivingEntity)wolf, level);
            }
            if (!TauntHandler.isTauntActive((LivingEntity)wolf)) continue;
            event.setNewAboutToBeSetTarget((LivingEntity)wolf);
            wolf.setTarget(attacker);
            return;
        }
    }

    private static boolean activateTaunt(LivingEntity entity) {
        long now = entity.level().getGameTime();
        if (tauntCooldownUntil.getOrDefault(entity.getUUID(), 0L) > now) {
            return false;
        }
        tauntActiveUntil.put(entity.getUUID(), now + 600L);
        tauntCooldownUntil.put(entity.getUUID(), now + 600L + 1200L);
        return true;
    }

    private static boolean isTauntActive(LivingEntity entity) {
        long now = entity.level().getGameTime();
        return tauntActiveUntil.getOrDefault(entity.getUUID(), 0L) > now;
    }

    private static void triggerTauntParticles(LivingEntity entity, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, entity.getX(), entity.getY() + 1.0, entity.getZ(), 10, 0.5, 0.5, 0.5, 0.05);
        }
    }
}

