/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.items;

import com.playerstats.event.PlayerAttributePersistence;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AbilityCrystalItem
extends Item {
    public AbilityCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.playerstats.ability_crystal.message").withStyle(ChatFormatting.YELLOW));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(null, player.getOnPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
            PlayerAttributePersistence.addAbilityPoints(player, 1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.playerstats.ability_crystal.hoverText").withStyle(ChatFormatting.AQUA));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

