/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.util;

import com.playerstats.ModAttributes;
import com.playerstats.event.PlayerAttributePersistence;
import com.playerstats.util.AttributeUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.registries.DeferredHolder;

public class UniqueAbilitiesUtils {
    public static boolean validateAbility(LivingEntity entity, Player player, String attributeId, boolean state) {
        if (attributeId.contains("follow_owner") || attributeId.contains("defend_owner") || attributeId.contains("taunt")) {
            if (!entity.getPersistentData().contains("Owner")) {
                entity.getPersistentData().putUUID("Owner", player.getUUID());
            }
            if (attributeId.contains("follow_owner")) {
                UniqueAbilitiesUtils.disableAbility(ModAttributes.PATROL, entity);
            }
        } else if (attributeId.contains("teleport_to_owner")) {
            if (AttributeUtils.getAttributeValue(entity, ModAttributes.FOLLOW_OWNER) == -1.0) {
                player.sendSystemMessage((Component)Component.translatable((String)"gui.playerstats.teleport_locked"));
                return false;
            }
            if (state) {
                UniqueAbilitiesUtils.disableAbility(ModAttributes.PATROL, entity);
            }
        } else if (attributeId.contains("life_regen")) {
            if (state) {
                entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, Integer.MAX_VALUE, 0, true, false));
            } else {
                entity.removeEffect(MobEffects.REGENERATION);
            }
        } else if (attributeId.contains("patrol") && state) {
            UniqueAbilitiesUtils.disableAbility(ModAttributes.FOLLOW_OWNER, entity);
            UniqueAbilitiesUtils.disableAbility(ModAttributes.TELEPORT_TO_OWNER, entity);
            entity.getPersistentData().putDouble("PatrolX", entity.getX());
            entity.getPersistentData().putDouble("PatrolY", entity.getY());
            entity.getPersistentData().putDouble("PatrolZ", entity.getZ());
        } else {
            return !attributeId.contains("rebirth") || state;
        }
        return true;
    }

    private static void disableAbility(DeferredHolder<Attribute, Attribute> ability, LivingEntity entity) {
        AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, (Attribute)ability.get());
        if (instance == null) {
            return;
        }
        if (AttributeUtils.getAttributeValue(entity, ability) == 1.0) {
            PlayerAttributePersistence.applyModifier(instance, ((Attribute)ability.get()).getDescriptionId(), 1.0);
        }
    }
}

