/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.entities.goals;

import com.playerstats.ModAttributes;
import com.playerstats.util.AttributeUtils;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FollowOwnerGoal
extends Goal {
    private final Mob mob;
    private Player owner;
    private final double speed = 1.2;
    private final float minDist = 6.0f;
    private final float maxDist = 15.0f;

    public FollowOwnerGoal(Mob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        try {
            UUID ownerId = this.mob.getPersistentData().m_128342_("Owner");
            if (ownerId == null) {
                return false;
            }
            this.owner = this.mob.m_9236_().m_46003_(ownerId);
            return this.owner != null && !this.mob.m_20159_() && !this.mob.m_21523_() && this.mob.m_20270_((Entity)this.owner) > 6.0f;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean m_8045_() {
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        return this.owner != null && this.mob.m_20270_((Entity)this.owner) > 15.0f && !this.mob.m_20159_() && !this.mob.m_21523_();
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        if (AttributeUtils.getAttributeValue((LivingEntity)this.mob, ModAttributes.FOLLOW_OWNER) < 1.0) {
            return;
        }
        double distance = this.mob.m_20270_((Entity)this.owner);
        if (distance > 12.0 && AttributeUtils.getAttributeValue((LivingEntity)this.mob, ModAttributes.TELEPORT_TO_OWNER) == 1.0) {
            this.teleportToOwner();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.owner, 1.2);
        }
    }

    private void teleportToOwner() {
        if (this.owner == null) {
            return;
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dy = 0; dy >= -2; --dy) {
                    Vec3 target = this.owner.m_20182_().m_82520_((double)dx, (double)dy, (double)dz);
                    BlockPos pos = BlockPos.m_274446_((Position)target);
                    BlockPos below = pos.m_7495_();
                    if (!this.mob.m_9236_().m_8055_(pos).m_60812_((BlockGetter)this.mob.m_9236_(), pos).m_83281_() || !this.mob.m_9236_().m_8055_(below).m_60804_((BlockGetter)this.mob.m_9236_(), below)) continue;
                    this.mob.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
                    this.mob.m_21573_().m_26573_();
                    return;
                }
            }
        }
    }
}

