/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.entities.goals;

import com.playerstats.ModAttributes;
import com.playerstats.util.AttributeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class PatrolGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private final double radius;
    private BlockPos patrolCenter;
    private int cooldown;

    public PatrolGoal(Mob mob, double speed, double radius) {
        this.mob = mob;
        this.speed = speed;
        this.radius = radius;
    }

    public boolean m_8036_() {
        return AttributeUtils.getAttributeValue((LivingEntity)this.mob, ModAttributes.PATROL) == 1.0;
    }

    public void m_8056_() {
        this.patrolCenter = new BlockPos(this.mob.getPersistentData().m_128451_("PatrolX"), this.mob.getPersistentData().m_128451_("PatrolY"), this.mob.getPersistentData().m_128451_("PatrolZ"));
    }

    public void m_8037_() {
        List hostiles;
        Level level = this.mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (--this.cooldown <= 0) {
            this.cooldown = 60;
            double angle = this.mob.m_217043_().m_188500_() * Math.PI * 2.0;
            int dx = (int)((double)this.patrolCenter.m_123341_() + Math.cos(angle) * this.radius);
            int dz = (int)((double)this.patrolCenter.m_123343_() + Math.sin(angle) * this.radius);
            BlockPos target = new BlockPos(dx, this.patrolCenter.m_123342_(), dz);
            this.mob.m_21573_().m_26519_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), this.speed);
        }
        if (!(hostiles = serverLevel.m_6443_(Monster.class, new AABB(this.patrolCenter).m_82400_(this.radius), Entity::m_6084_)).isEmpty()) {
            this.mob.m_6710_((LivingEntity)hostiles.get(0));
        }
    }
}

