/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import com.playerstats.entities.goals.DefendOwnerTargetGoal;
import com.playerstats.entities.goals.FollowOwnerGoal;
import com.playerstats.entities.goals.PatrolGoal;
import com.playerstats.items.ModItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class ModAbilityEvents {
    private static final Map<UUID, Long> howlCooldowns = new HashMap<UUID, Long>();
    private static final long HOWL_COOLDOWN_TICKS = 6000L;

    @SubscribeEvent
    public static void onHorseTamed(AnimalTameEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)livingEntity;
            horse.getPersistentData().m_128362_("Owner", event.getTamer().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((Mob)horse));
        }
        if ((entity = event.getEntity()) instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            golem.f_21346_.m_25352_(1, (Goal)new DefendOwnerTargetGoal(golem));
            golem.f_21346_.m_25352_(3, (Goal)new FollowOwnerGoal((Mob)golem));
            golem.f_21345_.m_25352_(5, (Goal)new PatrolGoal((Mob)golem, 1.0, 16.0));
        }
    }

    @SubscribeEvent
    public static void onHorseTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AbstractHorse)) {
            return;
        }
        AbstractHorse horse = (AbstractHorse)livingEntity;
        Level level = horse.m_9236_();
        if (level.f_46443_) {
            return;
        }
        boolean hasFrostWalker = ModAttributes.FROST_WALKER.getHolder().flatMap(holder -> Optional.ofNullable(horse.m_21204_().m_246600_(holder))).map(instance -> instance.m_22135_() == 1.0).orElse(false);
        if (hasFrostWalker) {
            BlockPos pos = horse.m_20183_();
            int frostLevel = 1;
            FrostWalkerEnchantment.m_45018_((LivingEntity)horse, (Level)level, (BlockPos)pos, (int)frostLevel);
        }
    }

    @SubscribeEvent
    public static void onMobDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        AttributeInstance revivable = entity.m_21051_((Attribute)ModAttributes.REBIRTH.get());
        if (revivable != null && revivable.m_22135_() == 1.0) {
            ItemStack soulFragment = new ItemStack((ItemLike)ModItems.SOUL_FRAGMENT.get());
            System.out.println(7);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                CompoundTag soulData = new CompoundTag();
                player.m_20240_(soulData);
                soulFragment.m_41784_().m_128365_("StoredEntity", (Tag)soulData);
                soulData.m_128359_("id", "minecraft:player");
                soulData.m_128359_("UUID", player.m_20148_().toString());
                soulFragment.m_41784_().m_128359_("StoredEntityName", Component.Serializer.m_130703_((Component)player.m_5446_()));
            } else {
                CompoundTag soulData = new CompoundTag();
                entity.m_20223_(soulData);
                soulFragment.m_41784_().m_128365_("StoredEntity", (Tag)soulData);
                soulFragment.m_41784_().m_128359_("StoredEntityName", Component.Serializer.m_130703_((Component)entity.m_5446_()));
            }
            ItemEntity drop = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soulFragment);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public static void onWolfTargetChange(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)livingEntity;
        if (wolf.m_269323_() == null) {
            return;
        }
        if (event.getNewTarget() == null) {
            return;
        }
        long lastHowl = howlCooldowns.getOrDefault(wolf.m_20148_(), 0L);
        if (wolf.m_9236_().m_46467_() - lastHowl < 6000L) {
            return;
        }
        if (wolf.m_21051_((Attribute)ModAttributes.HOWL_BUFF.get()).m_22135_() != 1.0) {
            return;
        }
        howlCooldowns.put(wolf.m_20148_(), wolf.m_9236_().m_46467_());
        double howlRadius = 8.0;
        List allies = wolf.m_9236_().m_6443_(Wolf.class, wolf.m_20191_().m_82400_(howlRadius), w -> w.m_6084_() && w != wolf);
        for (Wolf ally : allies) {
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 1));
        }
        Player owner = (Player)wolf.m_269323_();
        owner.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
        owner.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
        owner.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 1));
        wolf.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
        wolf.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
        wolf.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 1));
        Level level = wolf.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123746_, wolf.m_20185_(), wolf.m_20186_() + 1.0, wolf.m_20189_(), 20, 0.5, 0.5, 0.5, 0.1);
        }
        wolf.m_5496_(SoundEvents.f_12620_, 1.0f, 1.0f);
    }
}

