/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.event.PlayerAttributePersistence;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class PlayerPointHandler {
    private static final Map<UUID, Long> lastDayPointGiven = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int totalKills = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12936_));
        if (totalKills > 0 && (totalKills == 100 || totalKills % 1000 == 0)) {
            player.m_213846_((Component)Component.m_237110_((String)"event.playerstats.mobs_killed", (Object[])new Object[]{totalKills}));
            PlayerPointHandler.givePoint(player);
        }
        LivingEntity mob = event.getEntity();
        double baseChance = 0.0;
        if (PlayerPointHandler.isProgressiveBossesInstalled() && String.valueOf(mob.m_6095_()).contains("wither") && !String.valueOf(mob.m_6095_()).contains("skeleton")) {
            baseChance = (Double)Config.WITHER_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Wither killed via Progressive Bosses!");
                player.m_213846_((Component)Component.m_237113_((String)"PlayerStatsDebug: Wither killed via Progressive Bosses!"));
            }
            PlayerPointHandler.processChance(player, baseChance);
            return;
        }
        if (mob.m_6095_() == EntityType.f_20496_) {
            baseChance = (Double)Config.WITHER_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Wither killed!");
                player.m_213846_((Component)Component.m_237113_((String)"PlayerStatsDebug: Wither killed!"));
            }
        } else if (mob.m_6095_() == EntityType.f_20565_) {
            baseChance = (Double)Config.ENDER_DRAGON_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Ender dragon killed!");
                player.m_213846_((Component)Component.m_237113_((String)"PlayerStatsDebug: Ender dragon killed!"));
            }
        } else if (mob.m_6095_() == EntityType.f_217015_) {
            baseChance = (Double)Config.WARDEN_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Warden killed!");
                player.m_213846_((Component)Component.m_237113_((String)"PlayerStatsDebug: Warden killed!"));
            }
        } else if (mob.m_6095_() == EntityType.f_20563_) {
            baseChance = (Double)Config.ELDER_GUARDIAN_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Elder guardian killed!");
                player.m_213846_((Component)Component.m_237113_((String)"PlayerStatsDebug: Elder guardian killed!"));
            }
        } else if (mob.m_21233_() >= (float)((Integer)Config.HIGH_HEALTH.get()).intValue()) {
            baseChance = (Double)Config.HIGH_HEALTH_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("High health mob killed {}", (Object)mob.m_6095_());
                player.m_213846_((Component)Component.m_237113_((String)String.format("PlayerStatsDebug: High health mob killed %s", mob.m_6095_())));
            }
        }
        if (Config.cachedCustomMobChances.containsKey(mob.m_6095_().m_20675_())) {
            baseChance = Config.cachedCustomMobChances.get(mob.m_6095_().m_20675_());
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Custom mob killed: {}", (Object)mob.m_6095_());
                player.m_213846_((Component)Component.m_237113_((String)String.format("PlayerStatsDebug: Custom mob killed: %s", mob.m_6095_())));
            }
        }
        if (baseChance == 0.0) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob killed with no point chance: {}", (Object)mob.m_6095_());
                player.m_213846_((Component)Component.m_237113_((String)String.format("PlayerStatsDebug: Mob killed with no point chance: %s", mob.m_6095_())));
            }
            return;
        }
        PlayerPointHandler.processChance(player, baseChance);
    }

    private static void processChance(ServerPlayer player, double baseChance) {
        if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
            PlayerStats.LOGGER.info("Point chance: {}", (Object)baseChance);
            player.m_213846_((Component)Component.m_237113_((String)String.format("PlayerStatsDebug: Point chance: %s", baseChance)));
        }
        if (player.m_9236_().f_46441_.m_188500_() < baseChance) {
            PlayerPointHandler.givePoint(player);
        }
    }

    private static void givePoint(ServerPlayer player) {
        long currentDay = player.m_9236_().m_46468_() / 24000L;
        UUID uuid = player.m_20148_();
        Long lastGiven = lastDayPointGiven.getOrDefault(uuid, -1L);
        if (lastGiven == currentDay) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Player {} already received points today, ignoring.", (Object)player.m_7755_().getString());
                player.m_213846_((Component)Component.m_237113_((String)String.format("PlayerStatsDebug: Player %s already received points today, ignoring.", player.m_7755_().getString())));
            }
            return;
        }
        lastDayPointGiven.put(uuid, currentDay);
        PlayerAttributePersistence.addPoints((Player)player, 1);
    }

    public static boolean isProgressiveBossesInstalled() {
        if (ModList.get().isLoaded("progressivebosses")) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Progressive Bosses mod detected!");
            }
            return true;
        }
        return false;
    }
}

