/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.event.PlayerAttributePersistence;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ResetAttributesPacket {
    private final int entityId;

    public ResetAttributesPacket(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(ResetAttributesPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
    }

    public static ResetAttributesPacket decode(FriendlyByteBuf buf) {
        return new ResetAttributesPacket(buf.readInt());
    }

    public static void handle(ResetAttributesPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            Entity entity;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (entity = (level = player.m_9236_()).m_6815_(msg.entityId)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                PlayerAttributePersistence.resetAttributes(living, player, false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

