/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.client.ClientAttributeCache;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdatePointsPacket {
    private final int points;
    private final String pointsType;

    public UpdatePointsPacket(int points, String pointsType) {
        this.points = points;
        this.pointsType = pointsType;
    }

    public static void encode(UpdatePointsPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.points);
        buf.m_130070_(msg.pointsType);
    }

    public static UpdatePointsPacket decode(FriendlyByteBuf buf) {
        return new UpdatePointsPacket(buf.readInt(), buf.m_130277_());
    }

    public static void handle(UpdatePointsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (msg.pointsType.equals("attribute")) {
                ClientAttributeCache.setPoints(msg.points);
            } else if (msg.pointsType.equals("ability")) {
                ClientAttributeCache.setAbilityPoints(msg.points);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

