/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.entities.goals;

import com.playerstats.ModAttributes;
import com.playerstats.util.AttributeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class PatrolGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private final double radius;
    private BlockPos patrolCenter;
    private int cooldown;

    public PatrolGoal(Mob mob, double speed, double radius) {
        this.mob = mob;
        this.speed = speed;
        this.radius = radius;
    }

    public boolean canUse() {
        return AttributeUtils.getAttributeValue((LivingEntity)this.mob, ModAttributes.PATROL) == 1.0;
    }

    public void start() {
        this.patrolCenter = new BlockPos(this.mob.getPersistentData().getInt("PatrolX"), this.mob.getPersistentData().getInt("PatrolY"), this.mob.getPersistentData().getInt("PatrolZ"));
    }

    public void tick() {
        List hostiles;
        Level level = this.mob.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (--this.cooldown <= 0) {
            this.cooldown = 60;
            double angle = this.mob.getRandom().nextDouble() * Math.PI * 2.0;
            int dx = (int)((double)this.patrolCenter.getX() + Math.cos(angle) * this.radius);
            int dz = (int)((double)this.patrolCenter.getZ() + Math.sin(angle) * this.radius);
            BlockPos target = new BlockPos(dx, this.patrolCenter.getY(), dz);
            this.mob.getNavigation().moveTo((double)target.getX(), (double)target.getY(), (double)target.getZ(), this.speed);
        }
        if (!(hostiles = serverLevel.getEntitiesOfClass(Monster.class, new AABB(this.patrolCenter).inflate(this.radius), Entity::isAlive)).isEmpty()) {
            this.mob.setTarget((LivingEntity)hostiles.get(0));
        }
    }
}

