/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="playerstats")
public class ScoutVisionHandler {
    @SubscribeEvent
    public static void onParrotTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        double radius = 16.0;
        for (Player player : level.players()) {
            List parrots = level.getEntitiesOfClass(Parrot.class, player.getBoundingBox().inflate(radius), g -> {
                AttributeInstance attr = g.getAttribute(ModAttributes.SCOUT_VISION.getDelegate());
                return g.isAlive() && attr != null && attr.getValue() == 1.0;
            });
            boolean left = ScoutVisionHandler.hasScoutVision(player, true);
            boolean right = ScoutVisionHandler.hasScoutVision(player, false);
            if (left || right) {
                parrots.add(null);
            }
            for (Parrot parrot : parrots) {
                AABB visionBox = parrot != null ? parrot.getBoundingBox().inflate(radius) : player.getBoundingBox().inflate(radius);
                List mobs = level.getEntitiesOfClass(LivingEntity.class, visionBox, e -> e instanceof Monster || e instanceof Slime);
                for (LivingEntity mob : mobs) {
                    mob.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0, false, false));
                }
            }
        }
    }

    private static boolean hasScoutVision(Player player, boolean leftShoulder) {
        CompoundTag tag;
        CompoundTag compoundTag = tag = leftShoulder ? player.getShoulderEntityLeft() : player.getShoulderEntityRight();
        if (tag == null || tag.isEmpty()) {
            return false;
        }
        if (!"minecraft:parrot".equals(tag.getString("id"))) {
            return false;
        }
        if (!tag.contains("Attributes", 9)) {
            return false;
        }
        ListTag attributes = tag.getList("Attributes", 10);
        for (int i = 0; i < attributes.size(); ++i) {
            CompoundTag mod;
            double amount;
            ListTag mods;
            CompoundTag attr = attributes.getCompound(i);
            if (!"playerstats:scout_vision".equals(attr.getString("Name")) || !attr.contains("Modifiers", 9) || (mods = attr.getList("Modifiers", 10)).isEmpty() || -1.0 + (amount = (mod = mods.getCompound(0)).getDouble("Amount")) != 1.0) continue;
            return true;
        }
        return false;
    }
}

