/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.client.ClientAttributeCache;
import com.playerstats.client.ClientBoostCache;
import com.playerstats.event.PlayerAttributePersistence;
import com.playerstats.network.BoostsSyncPacket;
import com.playerstats.network.ModifyAttributePacket;
import com.playerstats.network.ResetAttributesPacket;
import com.playerstats.network.UpdatePointsPacket;
import com.playerstats.network.UpdateUpgradeCountPacket;
import com.playerstats.util.AttributeUtils;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    public static void register(IEventBus modEventBus) {
        modEventBus.addListener(PacketHandler::onRegisterPayloads);
    }

    private static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1.0");
        registrar.playToServer(ModifyAttributePacket.TYPE, ModifyAttributePacket.CODEC, PacketHandler::handleModifyAttribute);
        registrar.playToClient(UpdatePointsPacket.TYPE, UpdatePointsPacket.CODEC, PacketHandler::handleUpdatePoints);
        registrar.playToClient(UpdateUpgradeCountPacket.TYPE, UpdateUpgradeCountPacket.CODEC, PacketHandler::handleUpdateUpgradeCount);
        registrar.playToServer(ResetAttributesPacket.TYPE, ResetAttributesPacket.CODEC, PacketHandler::handleResetAttributes);
        registrar.playToClient(BoostsSyncPacket.TYPE, BoostsSyncPacket.CODEC, PacketHandler::sendBoostsToClient);
    }

    public static void sendToClient(CustomPacketPayload packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handleModifyAttribute(ModifyAttributePacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            Level level;
            Entity entity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (entity = (level = (player = (ServerPlayer)patt0$temp).level()).getEntity(msg.entityId())) instanceof LivingEntity) {
                AttributeInstance instance;
                LivingEntity living = (LivingEntity)entity;
                Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.tryParse((String)msg.attributeId()));
                if (attribute != null && (instance = AttributeUtils.getAttributeInstance(living, attribute)) != null) {
                    PlayerAttributePersistence.upgradeAttribute(living, player, msg.attributeId());
                }
            }
        });
    }

    private static void handleUpdatePoints(UpdatePointsPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (msg.pointsType().equals("attribute")) {
                ClientAttributeCache.setPoints(msg.points());
            } else if (msg.pointsType().equals("ability")) {
                ClientAttributeCache.setAbilityPoints(msg.points());
            }
        });
    }

    private static void handleUpdateUpgradeCount(UpdateUpgradeCountPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientAttributeCache.setUpgradeCount(packet.upgradeCount()));
    }

    private static void handleResetAttributes(ResetAttributesPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            Level level;
            Entity entity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (entity = (level = (player = (ServerPlayer)patt0$temp).level()).getEntity(msg.entityId())) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                PlayerAttributePersistence.resetAttributes(living, player, false);
            }
        });
    }

    public static void sendBoostsToClient(BoostsSyncPacket pkt, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientBoostCache.activeBoosts.clear();
            for (Map.Entry<ResourceLocation, BoostsSyncPacket.BoostData> entry : pkt.boosts.entrySet()) {
                Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(entry.getKey());
                if (attribute == null) continue;
                BoostsSyncPacket.BoostData bd = entry.getValue();
                ClientBoostCache.activeBoosts.put(attribute, new ClientBoostCache.BoostInfo(bd.amount, bd.secondsRemaining));
            }
        });
    }
}

