/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.client.ClientAttributeCache;
import com.playerstats.network.PacketHandler;
import com.playerstats.network.UpdatePointsPacket;
import com.playerstats.network.UpdateUpgradeCountPacket;
import com.playerstats.util.AttributeUtils;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class PlayerAttributePersistence {
    private static final String ATTRIBUTE_UPGRADES_TAG = "PlayerStatsUpgrades";
    private static final String POINTS_TAG = "PlayerStatsPoints";
    private static final String UPGRADE_COUNT_TAG = "PlayerStatsUpgradeCount";

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        CompoundTag originalNBT = event.getOriginal().getPersistentData();
        Player player = event.getEntity();
        ClientAttributeCache.clean();
        CompoundTag root = player.getPersistentData();
        root.m_128365_(ATTRIBUTE_UPGRADES_TAG, (Tag)originalNBT.m_128469_(ATTRIBUTE_UPGRADES_TAG));
        if (((Boolean)Config.RESET_ON_DEATH.get()).booleanValue()) {
            PlayerAttributePersistence.resetAttributes((ServerPlayer)player, true);
        } else {
            PlayerAttributePersistence.setPoints(player, PlayerAttributePersistence.getPoints(event.getOriginal()));
            CompoundTag upgradesTag = root.m_128469_(ATTRIBUTE_UPGRADES_TAG);
            for (String key : upgradesTag.m_128431_()) {
                ResourceLocation id = new ResourceLocation(key);
                Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
                AttributeInstance instance = player.m_21051_(attr);
                if (attr == null || instance == null) continue;
                int upgradeCount = upgradesTag.m_128451_(key);
                double increment = AttributeUtils.getIncrement(attr.m_22087_());
                PlayerStats.LOGGER.info("Configurando atributo:" + attr.m_22087_() + " valor atual: " + instance.m_22115_() + " upgrade count: " + upgradeCount + " increment: " + increment);
                double totalIncrement = (double)upgradeCount * increment;
                PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), totalIncrement);
            }
        }
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getPoints(player)), (ServerPlayer)player);
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(PlayerAttributePersistence.getUpgradeCount(player)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag root = player.getPersistentData();
        PlayerAttributePersistence.ensurePointsInitialized(player);
        ClientAttributeCache.clean();
        CompoundTag upgradesTag = root.m_128469_(ATTRIBUTE_UPGRADES_TAG);
        for (String key : upgradesTag.m_128431_()) {
            ResourceLocation id = new ResourceLocation(key);
            Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
            AttributeInstance instance = player.m_21051_(attr);
            if (attr == null || instance == null) continue;
            int upgradeCount = upgradesTag.m_128451_(key);
            double increment = AttributeUtils.getIncrement(attr.m_22087_());
            PlayerStats.LOGGER.info("Configurando atributo:" + attr.m_22087_() + " valor atual: " + instance.m_22115_() + " upgrade count: " + upgradeCount + " increment: " + increment);
            double totalIncrement = (double)upgradeCount * increment;
            PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), totalIncrement);
        }
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getPoints(player)), (ServerPlayer)player);
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(PlayerAttributePersistence.getUpgradeCount(player)), (ServerPlayer)player);
    }

    public static void upgradeAttribute(ServerPlayer player, String attributeId) {
        ResourceLocation id = new ResourceLocation(attributeId);
        Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
        if (attr != null) {
            AttributeInstance instance = player.m_21051_(attr);
            int playerPoints = PlayerAttributePersistence.getPoints((Player)player);
            int playerXpLevel = player.f_36078_;
            int playerUpgrades = PlayerAttributePersistence.getUpgradeCount((Player)player);
            int xpIncrement = (Integer)Config.XP_COST_INCREMENT.get();
            int xpCost = (playerUpgrades + 1) * xpIncrement;
            boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
            if (player.f_8941_.m_9290_() == GameType.CREATIVE) {
                consumeXp = false;
            }
            if (!(instance == null || playerPoints <= 0 || playerXpLevel < xpCost && consumeXp)) {
                PlayerAttributePersistence.applyUpgrade((Player)player, attr);
                PlayerAttributePersistence.setPoints((Player)player, playerPoints - 1);
                int newPoints = PlayerAttributePersistence.getPoints((Player)player);
                PacketHandler.sendToClient(new UpdatePointsPacket(newPoints), player);
                int count = PlayerAttributePersistence.getUpgradeCount((Player)player);
                PacketHandler.sendToClient(new UpdateUpgradeCountPacket(count), player);
                if (consumeXp) {
                    PlayerAttributePersistence.consumeExperience((Player)player, xpCost);
                }
            } else {
                System.err.println("AttributeInstance is null for: " + id);
            }
        } else {
            System.err.println("Unknown attribute ID: " + id);
        }
    }

    public static boolean setAttribute(ServerPlayer player, String attributeId, double value) {
        ResourceLocation id = new ResourceLocation(attributeId);
        Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
        if (attr != null) {
            AttributeInstance instance = player.m_21051_(attr);
            instance.m_22100_(value);
            return true;
        }
        System.err.println("AttributeInstance is null for: " + id);
        return false;
    }

    public static void applyUpgrade(Player player, Attribute attr) {
        ResourceLocation key = BuiltInRegistries.f_256951_.m_7981_((Object)attr);
        CompoundTag upgrades = player.getPersistentData().m_128469_(ATTRIBUTE_UPGRADES_TAG);
        int currentUpgrades = upgrades.m_128451_(key.toString()) + 1;
        upgrades.m_128405_(key.toString(), currentUpgrades);
        player.getPersistentData().m_128365_(ATTRIBUTE_UPGRADES_TAG, (Tag)upgrades);
        AttributeInstance instance = player.m_21051_(attr);
        if (instance != null) {
            double increment = AttributeUtils.getIncrement(attr.m_22087_());
            PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), increment * (double)currentUpgrades);
        }
        PlayerAttributePersistence.decrementPoints(player);
        PlayerAttributePersistence.incrementUpgradeCount(player);
    }

    private static int getUpgrades(Player player, String attrKey) {
        CompoundTag upgrades = player.getPersistentData().m_128469_(ATTRIBUTE_UPGRADES_TAG);
        return upgrades.m_128451_(attrKey);
    }

    public static void resetAttributes(ServerPlayer player, boolean resetByDeath) {
        boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
        int requiredXp = (Integer)Config.REQUIRED_XP_FOR_RESET.get();
        if (player.f_36078_ < requiredXp && player.f_8941_.m_9290_() != GameType.CREATIVE && !resetByDeath && consumeXp) {
            player.m_213846_((Component)Component.m_237110_((String)"gui.playerstats.cant_reset", (Object[])new Object[]{requiredXp}));
            return;
        }
        CompoundTag upgrades = player.getPersistentData().m_128469_(ATTRIBUTE_UPGRADES_TAG);
        int refundedPoints = 0;
        for (String key : upgrades.m_128431_()) {
            ResourceLocation id = new ResourceLocation(key);
            Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
            AttributeInstance instance = player.m_21051_(attr);
            if (attr == null || instance == null) continue;
            int upgradesApplied = upgrades.m_128451_(key);
            double increment = AttributeUtils.getIncrement(attr.m_22087_());
            instance.m_22122_().stream().filter(mod -> mod.m_22214_().equals("playerstats:" + attr.m_22087_())).toList().forEach(arg_0 -> ((AttributeInstance)instance).m_22130_(arg_0));
            refundedPoints += upgradesApplied;
        }
        player.getPersistentData().m_128473_(ATTRIBUTE_UPGRADES_TAG);
        player.getPersistentData().m_128473_(UPGRADE_COUNT_TAG);
        if (!resetByDeath) {
            PlayerAttributePersistence.setPoints((Player)player, PlayerAttributePersistence.getPoints((Player)player) + refundedPoints);
            if (consumeXp) {
                PlayerAttributePersistence.consumeExperience((Player)player, requiredXp);
            }
            player.m_213846_((Component)Component.m_237110_((String)"gui.playerstats.reset", (Object[])new Object[]{refundedPoints}));
        }
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getPoints((Player)player)), player);
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(0), player);
    }

    public static void consumeExperience(Player player, int level) {
        int points = level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        player.m_6756_(points * -1);
    }

    public static boolean ensurePointsInitialized(Player player) {
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_(POINTS_TAG)) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Configuring player points");
            }
            PlayerAttributePersistence.setPoints(player, 0);
            return false;
        }
        if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
            PlayerStats.LOGGER.info("Player points already configured");
        }
        return true;
    }

    private static void applyModifier(AttributeInstance instance, String attrId, double value) {
        instance.m_22122_().stream().filter(mod -> mod.m_22214_().equals("playerstats:" + attrId)).toList().forEach(arg_0 -> ((AttributeInstance)instance).m_22130_(arg_0));
        AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), "playerstats:" + attrId, value, AttributeModifier.Operation.ADDITION);
        instance.m_22125_(modifier);
    }

    public static int getPoints(Player player) {
        return player.getPersistentData().m_128451_(POINTS_TAG);
    }

    public static void setPoints(Player player, int points) {
        player.getPersistentData().m_128405_(POINTS_TAG, points);
    }

    public static void addPoints(Player player, int points) {
        CompoundTag tag = player.getPersistentData();
        int playerPoints = tag.m_128451_(POINTS_TAG);
        tag.m_128405_(POINTS_TAG, playerPoints + points);
    }

    public static void decrementPoints(Player player) {
        CompoundTag tag = player.getPersistentData();
        int current = tag.m_128451_(POINTS_TAG);
        tag.m_128405_(POINTS_TAG, Math.max(0, current - 1));
    }

    public static int getUpgradeCount(Player player) {
        return player.getPersistentData().m_128451_(UPGRADE_COUNT_TAG);
    }

    public static void incrementUpgradeCount(Player player) {
        CompoundTag tag = player.getPersistentData();
        int count = tag.m_128451_(UPGRADE_COUNT_TAG);
        tag.m_128405_(UPGRADE_COUNT_TAG, count + 1);
    }
}

