/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.event.PlayerAttributePersistence;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ModifyAttributePacket {
    private final String attributeId;

    public ModifyAttributePacket(String attributeId) {
        this.attributeId = attributeId;
    }

    public static void encode(ModifyAttributePacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.attributeId);
    }

    public static ModifyAttributePacket decode(FriendlyByteBuf buf) {
        return new ModifyAttributePacket(buf.m_130277_());
    }

    public static void handle(ModifyAttributePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                PlayerAttributePersistence.upgradeAttribute(player, msg.attributeId);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

