/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.util;

import com.playerstats.Config;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;

public class AttributeUtils {
    public static final Set<String> IGNORED_ATTRIBUTES = Set.of("attribute.name.generic.armor", "forge.name_tag_distance", "forge.entity.gravity", "forge.step_height", "attribute.name.generic.armor_toughness");

    public static double getIncrement(String descriptionId) {
        if (Config.cachedCustomAttributeIncrement.containsKey(descriptionId)) {
            return Config.cachedCustomAttributeIncrement.get(descriptionId);
        }
        return switch (descriptionId) {
            case "attribute.name.generic.luck" -> 1.0;
            case "attribute.name.generic.max_health" -> 2.0;
            case "attribute.name.generic.movement_speed" -> 0.01;
            case "forge.entity_reach", "forge.block_reach" -> 0.3;
            default -> 0.1;
        };
    }

    public static String getAttributeName(Attribute attr) {
        return Component.m_237115_((String)attr.m_22087_()).getString();
    }

    public static List<Attribute> getAttributes(Player player, String searchText) {
        return BuiltInRegistries.f_256951_.m_123024_().filter(attr -> {
            AttributeInstance instance = player.m_21204_().m_22146_(attr);
            if (instance == null || !instance.m_22099_().m_22086_()) {
                return false;
            }
            if (Config.cachedIgnoredAttributes.contains(attr.m_22087_())) {
                return false;
            }
            if (!searchText.isEmpty()) {
                String name = AttributeUtils.getAttributeName(attr).toLowerCase();
                return name.contains(searchText);
            }
            return true;
        }).toList();
    }
}

