/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.event.PlayerAttributePersistence;
import com.playerstats.network.PacketHandler;
import com.playerstats.network.UpdatePointsPacket;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class PlayerPointHandler {
    private static final Map<UUID, Long> lastDayPointGiven = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity mob = event.getEntity();
        double baseChance = 0.0;
        if (PlayerPointHandler.isProgressiveBossesInstalled() && String.valueOf(mob.m_6095_()).contains("wither") && !String.valueOf(mob.m_6095_()).contains("skeleton")) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Wither morto via Progressive Bosses!");
            }
            baseChance = 0.5;
            PlayerPointHandler.processChance(player, baseChance);
            return;
        }
        if (mob.m_6095_() == EntityType.f_20496_ || mob.m_6095_() == EntityType.f_20565_) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Wither/Ender dragon morto!");
            }
            baseChance = 0.5;
        } else if (mob.m_6095_() == EntityType.f_217015_) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Warden morto!");
            }
            baseChance = 0.3;
        } else if (mob.m_6095_() == EntityType.f_20563_) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Elder guardian morto!");
            }
            baseChance = 0.3;
        } else if (mob.m_21233_() > 200.0f) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob com mais de 200 de vida morto: {}", (Object)mob.m_6095_());
            }
            baseChance = 0.05;
        }
        if (Config.cachedCustomMobChances.containsKey(mob.m_6095_().m_20675_())) {
            baseChance = Config.cachedCustomMobChances.get(mob.m_6095_().m_20675_());
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob customizado morto: {}, chance configurada: {}", (Object)mob.m_6095_(), (Object)baseChance);
            }
        }
        if (baseChance == 0.0) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob morto sem chances de pontos: {}", (Object)mob.m_6095_());
            }
            return;
        }
        PlayerPointHandler.processChance(player, baseChance);
    }

    private static void processChance(ServerPlayer player, double baseChance) {
        if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
            PlayerStats.LOGGER.info("Chances de ponto: {}", (Object)baseChance);
        }
        if (player.m_9236_().f_46441_.m_188500_() < baseChance) {
            PlayerPointHandler.givePoints(player, 1);
        }
    }

    private static void givePoints(ServerPlayer player, int amount) {
        long currentDay = player.m_9236_().m_46468_() / 24000L;
        UUID uuid = player.m_20148_();
        Long lastGiven = lastDayPointGiven.getOrDefault(uuid, -1L);
        if (lastGiven == currentDay) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Player {} j\u00e1 recebeu pontos hoje, ignorando.", (Object)player.m_7755_());
            }
            return;
        }
        lastDayPointGiven.put(uuid, currentDay);
        PlayerAttributePersistence.addPoints((Player)player, amount);
        int newPoints = PlayerAttributePersistence.getPoints((Player)player);
        PacketHandler.sendToClient(new UpdatePointsPacket(newPoints), player);
        player.m_213846_((Component)Component.m_237115_((String)"event.playerstats.point_given"));
    }

    public static boolean isProgressiveBossesInstalled() {
        if (ModList.get().isLoaded("progressivebosses")) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Detectado mod Progressive Bosses!");
            }
            return true;
        }
        return false;
    }

    public static boolean isBloodMoon(Level world) {
        if (ModList.get().isLoaded("majruszsdifficulty")) {
            try {
                Class<?> helperClass = Class.forName("com.majruszsdifficulty.events.BloodMoonHelper");
                Method method = helperClass.getDeclaredMethod("isBloodMoon", Level.class);
                return (Boolean)method.invoke(null, world);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

