/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.client.ClientAttributeCache;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdatePointsPacket {
    private final int points;

    public UpdatePointsPacket(int points) {
        this.points = points;
    }

    public static void encode(UpdatePointsPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.points);
    }

    public static UpdatePointsPacket decode(FriendlyByteBuf buf) {
        return new UpdatePointsPacket(buf.readInt());
    }

    public static void handle(UpdatePointsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientAttributeCache.setPoints(msg.points));
        ctx.get().setPacketHandled(true);
    }
}

