/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.client.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CustomButton
extends Button {
    private final MutableComponent LABEL;
    private final Font font;
    private final ResourceLocation TEXTURE;

    public CustomButton(int x, int y, int width, int height, MutableComponent label, ResourceLocation texture, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.font = Minecraft.getInstance().font;
        this.LABEL = label;
        this.TEXTURE = texture;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int texY = this.isHovered() ? this.height : 0;
        graphics.blit(this.TEXTURE, this.getX(), this.getY(), 0.0f, (float)texY, this.width, this.height, this.width, this.height * 2);
        int textX = this.getX() + (this.width - this.font.width((FormattedText)this.LABEL)) / 2;
        int textY = this.getY() + (this.height - 8) / 2;
        graphics.drawString(this.font, (Component)this.LABEL, textX, textY, 0xFFFFFF, false);
    }
}

