/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.event.PlayerAttributePersistence;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="playerstats")
public class PlayerPointHandler {
    private static final Map<UUID, Long> lastDayPointGiven = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int totalKills = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.MOB_KILLS));
        if (totalKills > 0 && (totalKills == 100 || totalKills % 1000 == 0)) {
            player.sendSystemMessage((Component)Component.translatable((String)"event.playerstats.mobs_killed", (Object[])new Object[]{totalKills}));
            PlayerPointHandler.givePoint(player);
        }
        LivingEntity mob = event.getEntity();
        double baseChance = 0.0;
        if (mob.getType() == EntityType.WITHER) {
            baseChance = (Double)Config.WITHER_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Wither killed!");
                player.sendSystemMessage((Component)Component.literal((String)"PlayerStatsDebug: Wither killed!"));
            }
        } else if (mob.getType() == EntityType.ENDER_DRAGON) {
            baseChance = (Double)Config.ENDER_DRAGON_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Ender dragon killed!");
                player.sendSystemMessage((Component)Component.literal((String)"PlayerStatsDebug: Ender dragon killed!"));
            }
        } else if (mob.getType() == EntityType.WARDEN) {
            baseChance = (Double)Config.WARDEN_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Warden killed!");
                player.sendSystemMessage((Component)Component.literal((String)"PlayerStatsDebug: Warden killed!"));
            }
        } else if (mob.getType() == EntityType.ELDER_GUARDIAN) {
            baseChance = (Double)Config.ELDER_GUARDIAN_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Elder guardian killed!");
                player.sendSystemMessage((Component)Component.literal((String)"PlayerStatsDebug: Elder guardian killed!"));
            }
        } else if (mob.getMaxHealth() >= (float)((Integer)Config.HIGH_HEALTH.get()).intValue()) {
            baseChance = (Double)Config.HIGH_HEALTH_CHANCE.get();
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("High health mob killed {}", (Object)mob.getType());
                player.sendSystemMessage((Component)Component.literal((String)String.format("PlayerStatsDebug: High health mob killed %s", mob.getType())));
            }
        }
        if (Config.cachedCustomMobChances.containsKey(mob.getType().getDescriptionId())) {
            baseChance = Config.cachedCustomMobChances.get(mob.getType().getDescriptionId());
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Custom mob killed: {}", (Object)mob.getType());
                player.sendSystemMessage((Component)Component.literal((String)String.format("PlayerStatsDebug: Custom mob killed: %s", mob.getType())));
            }
        }
        if (baseChance == 0.0) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Mob killed with no point chance: {}", (Object)mob.getType());
                player.sendSystemMessage((Component)Component.literal((String)String.format("PlayerStatsDebug: Mob killed with no point chance: %s", mob.getType())));
            }
            return;
        }
        PlayerPointHandler.processChance(player, baseChance);
    }

    private static void processChance(ServerPlayer player, double baseChance) {
        if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
            PlayerStats.LOGGER.info("Point chance: {}", (Object)baseChance);
            player.sendSystemMessage((Component)Component.literal((String)String.format("PlayerStatsDebug: Point chance: %s", baseChance)));
        }
        if (player.level().random.nextDouble() < baseChance) {
            PlayerPointHandler.givePoint(player);
        }
    }

    private static void givePoint(ServerPlayer player) {
        long currentDay = player.level().getDayTime() / 24000L;
        UUID uuid = player.getUUID();
        Long lastGiven = lastDayPointGiven.getOrDefault(uuid, -1L);
        if (lastGiven == currentDay) {
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                PlayerStats.LOGGER.info("Player {} already received points today, ignoring.", (Object)player.getName().getString());
                player.sendSystemMessage((Component)Component.literal((String)String.format("PlayerStatsDebug: Player %s already received points today, ignoring.", player.getName().getString())));
            }
            return;
        }
        lastDayPointGiven.put(uuid, currentDay);
        PlayerAttributePersistence.addPoints((Player)player, 1);
    }
}

