/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class TauntHandler {
    private static final Map<UUID, Long> tauntActiveUntil = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> tauntCooldownUntil = new HashMap<UUID, Long>();
    private static final long DURATION_TICKS = 600L;
    private static final long COOLDOWN_TICKS = 1200L;

    @SubscribeEvent
    public static void onTargetSet(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof IronGolem)) {
            return;
        }
        IronGolem golem = (IronGolem)livingEntity;
        LivingEntity newTarget = event.getNewTarget();
        if (newTarget != null && golem.getPersistentData().m_128403_("Owner")) {
            UUID ownerId = golem.getPersistentData().m_128342_("Owner");
            if (newTarget.m_20148_().equals(ownerId)) {
                event.setNewTarget(null);
            }
        }
    }

    @SubscribeEvent
    public static void onTargetChange(LivingChangeTargetEvent event) {
        Wolf wolf;
        LivingEntity attacker = event.getEntity();
        LivingEntity originalTarget = event.getOriginalTarget();
        if (!(originalTarget instanceof ServerPlayer)) {
            return;
        }
        Level level = attacker.m_9236_();
        if (attacker.getPersistentData().m_128441_("Owner") && originalTarget.m_20148_().equals(attacker.getPersistentData().m_128342_("Owner"))) {
            event.setCanceled(true);
            return;
        }
        List golems = level.m_6443_(IronGolem.class, attacker.m_20191_().m_82400_(16.0), g -> g.m_6084_() && g.m_21051_((Attribute)ModAttributes.TAUNT.get()) != null && g.m_21051_((Attribute)ModAttributes.TAUNT.get()).m_22135_() == 1.0);
        for (IronGolem golem : golems) {
            if (attacker == golem) continue;
            if (TauntHandler.activateTaunt((LivingEntity)golem)) {
                TauntHandler.triggerTauntParticles((LivingEntity)golem, level);
            }
            if (!TauntHandler.isTauntActive((LivingEntity)golem)) continue;
            event.setNewTarget((LivingEntity)golem);
            golem.m_6710_(attacker);
            return;
        }
        List wolves = level.m_6443_(Wolf.class, attacker.m_20191_().m_82400_(16.0), w -> w.m_6084_() && w.m_21051_((Attribute)ModAttributes.TAUNT.get()) != null && w.m_21051_((Attribute)ModAttributes.TAUNT.get()).m_22135_() == 1.0);
        Iterator iterator = wolves.iterator();
        while (iterator.hasNext() && attacker != (wolf = (Wolf)iterator.next())) {
            if (TauntHandler.activateTaunt((LivingEntity)wolf)) {
                TauntHandler.triggerTauntParticles((LivingEntity)wolf, level);
            }
            if (!TauntHandler.isTauntActive((LivingEntity)wolf)) continue;
            event.setNewTarget((LivingEntity)wolf);
            wolf.m_6710_(attacker);
            return;
        }
    }

    private static boolean activateTaunt(LivingEntity entity) {
        long now = entity.m_9236_().m_46467_();
        if (tauntCooldownUntil.getOrDefault(entity.m_20148_(), 0L) > now) {
            return false;
        }
        tauntActiveUntil.put(entity.m_20148_(), now + 600L);
        tauntCooldownUntil.put(entity.m_20148_(), now + 600L + 1200L);
        return true;
    }

    private static boolean isTauntActive(LivingEntity entity) {
        long now = entity.m_9236_().m_46467_();
        return tauntActiveUntil.getOrDefault(entity.m_20148_(), 0L) > now;
    }

    private static void triggerTauntParticles(LivingEntity entity, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 10, 0.5, 0.5, 0.5, 0.05);
        }
    }
}

