/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.client.ClientBoostCache;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.network.NetworkEvent;

public class BoostsSyncPacket {
    private final Map<ResourceLocation, BoostData> boosts;

    public BoostsSyncPacket(Map<ResourceLocation, BoostData> boosts) {
        this.boosts = boosts;
    }

    public static void encode(BoostsSyncPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.boosts.size());
        for (Map.Entry<ResourceLocation, BoostData> entry : pkt.boosts.entrySet()) {
            buf.m_130085_(entry.getKey());
            buf.writeDouble(entry.getValue().amount);
            buf.writeInt(entry.getValue().secondsRemaining);
        }
    }

    public static BoostsSyncPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<ResourceLocation, BoostData> map = new HashMap<ResourceLocation, BoostData>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation attrId = buf.m_130281_();
            double amount = buf.readDouble();
            int seconds = buf.readInt();
            map.put(attrId, new BoostData(amount, seconds));
        }
        return new BoostsSyncPacket(map);
    }

    public static void handle(BoostsSyncPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientBoostCache.activeBoosts.clear();
            for (Map.Entry<ResourceLocation, BoostData> entry : pkt.boosts.entrySet()) {
                Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(entry.getKey());
                if (attribute == null) continue;
                BoostData bd = entry.getValue();
                ClientBoostCache.activeBoosts.put(attribute, new ClientBoostCache.BoostInfo(bd.amount, bd.secondsRemaining));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class BoostData {
        public final double amount;
        public final int secondsRemaining;

        public BoostData(double amount, int secondsRemaining) {
            this.amount = amount;
            this.secondsRemaining = secondsRemaining;
        }
    }
}

