/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.util;

import com.playerstats.ModAttributes;
import com.playerstats.event.PlayerAttributePersistence;
import com.playerstats.util.AttributeUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.RegistryObject;

public class UniqueAbilitiesUtils {
    public static boolean validateAbility(LivingEntity entity, Player player, String attributeId, boolean state) {
        if (attributeId.contains("follow_owner") || attributeId.contains("defend_owner") || attributeId.contains("taunt")) {
            if (!entity.getPersistentData().m_128441_("Owner")) {
                entity.getPersistentData().m_128362_("Owner", player.m_20148_());
            }
            if (attributeId.contains("follow_owner")) {
                UniqueAbilitiesUtils.disableAbility(ModAttributes.PATROL, entity);
            }
        } else if (attributeId.contains("teleport_to_owner")) {
            if (AttributeUtils.getAttributeValue(entity, ModAttributes.FOLLOW_OWNER) == -1.0) {
                player.m_213846_((Component)Component.m_237115_((String)"gui.playerstats.teleport_locked"));
                return false;
            }
            if (state) {
                UniqueAbilitiesUtils.disableAbility(ModAttributes.PATROL, entity);
            }
        } else if (attributeId.contains("life_regen")) {
            if (state) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Integer.MAX_VALUE, 0, true, false));
            } else {
                entity.m_21195_(MobEffects.f_19605_);
            }
        } else if (attributeId.contains("patrol") && state) {
            UniqueAbilitiesUtils.disableAbility(ModAttributes.FOLLOW_OWNER, entity);
            UniqueAbilitiesUtils.disableAbility(ModAttributes.TELEPORT_TO_OWNER, entity);
            entity.getPersistentData().m_128347_("PatrolX", entity.m_20185_());
            entity.getPersistentData().m_128347_("PatrolY", entity.m_20186_());
            entity.getPersistentData().m_128347_("PatrolZ", entity.m_20189_());
        } else {
            return !attributeId.contains("rebirth") || state;
        }
        return true;
    }

    private static void disableAbility(RegistryObject<Attribute> ability, LivingEntity entity) {
        AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, (Attribute)ability.get());
        if (instance == null) {
            return;
        }
        if (AttributeUtils.getAttributeValue(entity, ability) == 1.0) {
            PlayerAttributePersistence.applyModifier(instance, ((Attribute)ability.get()).m_22087_(), 1.0);
        }
    }
}

