/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.Config;
import com.playerstats.PlayerStats;
import com.playerstats.client.ClientAttributeCache;
import com.playerstats.client.KeyMappings;
import com.playerstats.network.PacketHandler;
import com.playerstats.network.UpdatePointsPacket;
import com.playerstats.network.UpdateUpgradeCountPacket;
import com.playerstats.util.AttributeUtils;
import com.playerstats.util.UniqueAbilitiesUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(modid="playerstats")
public class PlayerAttributePersistence {
    private static final String ATTRIBUTE_UPGRADES_TAG = "PlayerStatsUpgrades";
    private static final String POINTS_TAG = "PlayerStatsPoints";
    private static final String UPGRADE_COUNT_TAG = "PlayerStatsUpgradeCount";
    private static final String ABILITY_POINTS_TAG = "PlayerAbilityPoints";

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        CompoundTag originalNBT = event.getOriginal().getPersistentData();
        Player player = event.getEntity();
        ClientAttributeCache.clean();
        CompoundTag root = player.getPersistentData();
        root.m_128365_(ATTRIBUTE_UPGRADES_TAG, (Tag)originalNBT.m_128469_(ATTRIBUTE_UPGRADES_TAG));
        if (((Boolean)Config.RESET_ON_DEATH.get()).booleanValue()) {
            PlayerAttributePersistence.resetAttributes((LivingEntity)player, (ServerPlayer)player, true);
        } else {
            PlayerAttributePersistence.setPoints(player, PlayerAttributePersistence.getPoints(event.getOriginal()));
            PlayerAttributePersistence.setAbilityPoints(player, PlayerAttributePersistence.getPoints(event.getOriginal()));
            CompoundTag upgradesTag = root.m_128469_(ATTRIBUTE_UPGRADES_TAG);
            for (String key : upgradesTag.m_128431_()) {
                ResourceLocation id = ResourceLocation.m_135820_((String)key);
                Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
                AttributeInstance instance = AttributeUtils.getAttributeInstance((LivingEntity)player, attr);
                if (attr == null || instance == null) continue;
                int upgradeCount = upgradesTag.m_128451_(key);
                double increment = AttributeUtils.getIncrement(attr.m_22087_());
                PlayerStats.LOGGER.info("Configurando atributo:{} valor atual: {} upgrade count: {} increment: {}", (Object)attr.m_22087_(), (Object)instance.m_22115_(), (Object)upgradeCount, (Object)increment);
                double totalIncrement = (double)upgradeCount * increment;
                PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), totalIncrement);
            }
        }
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(PlayerAttributePersistence.getUpgradeCount((LivingEntity)player)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ClientAttributeCache.clean();
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getPoints(player), "attribute"), (ServerPlayer)player);
        PacketHandler.sendToClient(new UpdatePointsPacket(PlayerAttributePersistence.getAbilityPoints(player), "ability"), (ServerPlayer)player);
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(PlayerAttributePersistence.getUpgradeCount((LivingEntity)player)), (ServerPlayer)player);
    }

    public static void upgradeAttribute(LivingEntity entity, ServerPlayer player, String attributeId) {
        ResourceLocation id = ResourceLocation.m_135820_((String)attributeId);
        Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
        if (attr != null) {
            AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, attr);
            if (!attributeId.startsWith("playerstats:")) {
                int playerPoints = PlayerAttributePersistence.getPoints((Player)player);
                int playerUpgrades = PlayerAttributePersistence.getUpgradeCount(entity);
                int xpIncrement = (Integer)Config.XP_COST_INCREMENT.get();
                int xpCost = (playerUpgrades + 1) * xpIncrement;
                boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
                if (player.f_8941_.m_9290_() == GameType.CREATIVE) {
                    consumeXp = false;
                }
                if (instance == null) {
                    System.err.println("AttributeInstance is null for: " + id);
                    return;
                }
                if (!(playerPoints <= 0 || player.f_36078_ < xpCost && consumeXp)) {
                    PlayerAttributePersistence.applyUpgrade(entity, attr);
                    PlayerAttributePersistence.setPoints((Player)player, playerPoints - 1);
                    int count = PlayerAttributePersistence.getUpgradeCount(entity);
                    PacketHandler.sendToClient(new UpdateUpgradeCountPacket(count), player);
                    if (consumeXp) {
                        PlayerAttributePersistence.consumeExperience((Player)player, xpCost);
                    }
                }
            } else {
                int playerPoints = PlayerAttributePersistence.getAbilityPoints((Player)player);
                if (instance.m_22135_() == -1.0) {
                    int xpCost = (Integer)Config.REQUIRED_XP_FOR_ABILITY.get();
                    boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
                    if (player.f_8941_.m_9290_() == GameType.CREATIVE) {
                        consumeXp = false;
                    }
                    if (!(playerPoints <= 0 || player.f_36078_ < xpCost && consumeXp)) {
                        if (!UniqueAbilitiesUtils.enableDisableAbility(entity, (Player)player, attributeId, true)) {
                            return;
                        }
                        PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), 2.0);
                        PlayerAttributePersistence.setAbilityPoints((Player)player, playerPoints - 1);
                        if (consumeXp) {
                            PlayerAttributePersistence.consumeExperience((Player)player, xpCost);
                        }
                    }
                } else if (instance.m_22135_() == 0.0) {
                    if (!UniqueAbilitiesUtils.enableDisableAbility(entity, (Player)player, attributeId, true)) {
                        return;
                    }
                    PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), 2.0);
                } else if (instance.m_22135_() == 1.0) {
                    if (!UniqueAbilitiesUtils.enableDisableAbility(entity, (Player)player, attributeId, false)) {
                        return;
                    }
                    PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), 1.0);
                }
            }
        } else {
            System.err.println("Unknown attribute ID: " + id);
        }
    }

    public static void applyUpgrade(LivingEntity entity, Attribute attr) {
        ResourceLocation key = BuiltInRegistries.f_256951_.m_7981_((Object)attr);
        CompoundTag upgrades = entity.getPersistentData().m_128469_(ATTRIBUTE_UPGRADES_TAG);
        int currentUpgrades = upgrades.m_128451_(key.toString()) + 1;
        upgrades.m_128405_(key.toString(), currentUpgrades);
        entity.getPersistentData().m_128365_(ATTRIBUTE_UPGRADES_TAG, (Tag)upgrades);
        AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, attr);
        if (instance != null) {
            double increment = AttributeUtils.getIncrement(attr.m_22087_());
            PlayerAttributePersistence.applyModifier(instance, attr.m_22087_(), increment * (double)currentUpgrades);
            PlayerAttributePersistence.incrementUpgradeCount(entity);
        }
    }

    public static void resetAttributes(LivingEntity entity, ServerPlayer player, boolean resetByDeath) {
        boolean consumeXp = (Boolean)Config.CONSUME_XP.get();
        int requiredXp = (Integer)Config.REQUIRED_XP_FOR_RESET.get();
        if (player.f_36078_ < requiredXp && player.f_8941_.m_9290_() != GameType.CREATIVE && !resetByDeath && consumeXp) {
            player.m_213846_((Component)Component.m_237110_((String)"gui.playerstats.cant_reset", (Object[])new Object[]{requiredXp}));
            return;
        }
        CompoundTag upgrades = entity.getPersistentData().m_128469_(ATTRIBUTE_UPGRADES_TAG);
        int refundedPoints = 0;
        for (String key : upgrades.m_128431_()) {
            ResourceLocation id = ResourceLocation.m_135820_((String)key);
            Attribute attr = (Attribute)BuiltInRegistries.f_256951_.m_7745_(id);
            AttributeInstance instance = AttributeUtils.getAttributeInstance(entity, attr);
            if (attr == null || instance == null) continue;
            int upgradesApplied = upgrades.m_128451_(key);
            instance.m_22122_().stream().filter(mod -> mod.m_22214_().equals("playerstats:" + attr.m_22087_())).toList().forEach(arg_0 -> ((AttributeInstance)instance).m_22130_(arg_0));
            refundedPoints += upgradesApplied;
        }
        entity.getPersistentData().m_128473_(ATTRIBUTE_UPGRADES_TAG);
        entity.getPersistentData().m_128473_(UPGRADE_COUNT_TAG);
        if (!resetByDeath) {
            PlayerAttributePersistence.setPoints((Player)player, PlayerAttributePersistence.getPoints((Player)player) + refundedPoints);
            if (consumeXp) {
                PlayerAttributePersistence.consumeExperience((Player)player, requiredXp);
            }
            player.m_213846_((Component)Component.m_237110_((String)"gui.playerstats.reset", (Object[])new Object[]{refundedPoints}));
        }
        PacketHandler.sendToClient(new UpdateUpgradeCountPacket(0), player);
    }

    public static void consumeExperience(Player player, int level) {
        int points = level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        player.m_6756_(points * -1);
    }

    private static void applyModifier(AttributeInstance instance, String attrId, double value) {
        instance.m_22122_().stream().filter(mod -> mod.m_22214_().equals("playerstats:" + attrId)).toList().forEach(arg_0 -> ((AttributeInstance)instance).m_22130_(arg_0));
        AttributeModifier modifier = new AttributeModifier("playerstats:" + attrId, value, AttributeModifier.Operation.ADDITION);
        instance.m_22125_(modifier);
    }

    public static int getPoints(Player player) {
        return player.getPersistentData().m_128451_(POINTS_TAG);
    }

    public static void setPoints(Player player, int points) {
        player.getPersistentData().m_128405_(POINTS_TAG, points);
        PacketHandler.sendToClient(new UpdatePointsPacket(points, "attribute"), (ServerPlayer)player);
    }

    public static int getAbilityPoints(Player player) {
        return player.getPersistentData().m_128451_(ABILITY_POINTS_TAG);
    }

    public static void setAbilityPoints(Player player, int points) {
        player.getPersistentData().m_128405_(ABILITY_POINTS_TAG, points);
        PacketHandler.sendToClient(new UpdatePointsPacket(points, "ability"), (ServerPlayer)player);
    }

    public static void addPoints(Player player, int points) {
        CompoundTag tag = player.getPersistentData();
        int playerPoints = tag.m_128451_(POINTS_TAG) + points;
        tag.m_128405_(POINTS_TAG, playerPoints);
        PacketHandler.sendToClient(new UpdatePointsPacket(playerPoints, "attribute"), (ServerPlayer)player);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            player.m_213846_((Component)Component.m_237110_((String)"event.playerstats.point_given", (Object[])new Object[]{KeyMappings.OPEN_STATS_KEY.getKey().m_84875_().getString()}));
        }
    }

    public static void addAbilityPoints(Player player, int points) {
        CompoundTag tag = player.getPersistentData();
        int playerPoints = tag.m_128451_(ABILITY_POINTS_TAG) + points;
        tag.m_128405_(ABILITY_POINTS_TAG, playerPoints);
        PacketHandler.sendToClient(new UpdatePointsPacket(playerPoints, "ability"), (ServerPlayer)player);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            player.m_213846_((Component)Component.m_237110_((String)"event.playerstats.ability_point_given", (Object[])new Object[]{KeyMappings.OPEN_STATS_KEY.getKey().m_84875_().getString()}));
        }
    }

    public static int getUpgradeCount(LivingEntity entity) {
        return entity.getPersistentData().m_128451_(UPGRADE_COUNT_TAG);
    }

    public static void incrementUpgradeCount(LivingEntity entity) {
        CompoundTag tag = entity.getPersistentData();
        int count = tag.m_128451_(UPGRADE_COUNT_TAG);
        tag.m_128405_(UPGRADE_COUNT_TAG, count + 1);
    }
}

