/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class ScoutVisionHandler {
    @SubscribeEvent
    public static void onParrotTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (level.m_5776_()) {
            return;
        }
        double radius = 16.0;
        for (Player player : level.m_6907_()) {
            List parrots = level.m_6443_(Parrot.class, player.m_20191_().m_82400_(radius), g -> g.m_21051_((Attribute)ModAttributes.SCOUT_VISION.get()) != null && g.m_21051_((Attribute)ModAttributes.SCOUT_VISION.get()).m_22135_() == 1.0 && g.m_6084_());
            boolean left = ScoutVisionHandler.hasScoutVision(player, true);
            boolean right = ScoutVisionHandler.hasScoutVision(player, false);
            if (left || right) {
                parrots.add(null);
            }
            for (Parrot parrot : parrots) {
                AABB visionBox = parrot != null ? parrot.m_20191_().m_82400_(radius) : player.m_20191_().m_82400_(radius);
                List mobs = level.m_6443_(LivingEntity.class, visionBox, e -> e instanceof Monster || e instanceof Slime);
                if (mobs.isEmpty()) continue;
                for (LivingEntity mob : mobs) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0, false, false));
                }
            }
        }
    }

    private static boolean hasScoutVision(Player player, boolean leftShoulder) {
        CompoundTag tag;
        CompoundTag compoundTag = tag = leftShoulder ? player.m_36331_() : player.m_36332_();
        if (tag == null || tag.m_128456_()) {
            return false;
        }
        if (!"minecraft:parrot".equals(tag.m_128461_("id"))) {
            return false;
        }
        if (!tag.m_128425_("Attributes", 9)) {
            return false;
        }
        ListTag attributes = tag.m_128437_("Attributes", 10);
        for (int i = 0; i < attributes.size(); ++i) {
            CompoundTag mod;
            double amount;
            ListTag mods;
            CompoundTag attr = attributes.m_128728_(i);
            if (!"playerstats:scout_vision".equals(attr.m_128461_("Name")) || !attr.m_128425_("Modifiers", 9) || (mods = attr.m_128437_("Modifiers", 10)).isEmpty() || -1.0 + (amount = (mod = mods.m_128728_(0)).m_128459_("Amount")) != 1.0) continue;
            return true;
        }
        return false;
    }
}

