/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.items.ModItems;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="playerstats")
public class SoulReviveHandler {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (level.m_5776_()) {
            return;
        }
        if (++tickCounter % 40 != 0) {
            return;
        }
        for (Player player : level.m_6907_()) {
            BlockPos pPos = player.m_20183_();
            AABB box = new AABB((double)(pPos.m_123341_() - 8), (double)(pPos.m_123342_() - 4), (double)(pPos.m_123343_() - 8), (double)(pPos.m_123341_() + 8), (double)(pPos.m_123342_() + 4), (double)(pPos.m_123343_() + 8));
            List items = level.m_45976_(ItemEntity.class, box);
            HashMap<BlockPos, ItemEntity> stones = new HashMap<BlockPos, ItemEntity>();
            for (ItemEntity ie : items) {
                ItemStack stack = ie.m_32055_();
                if (stack == null || stack.m_41720_() != ModItems.SOUL_STONE.get()) continue;
                stones.put(ie.m_20183_(), ie);
            }
            if (stones.isEmpty()) {
                return;
            }
            for (ItemEntity fragmentEntity : items) {
                List candidates;
                String entityId;
                CompoundTag storedEntityTag;
                CompoundTag tag;
                ItemStack fragStack = fragmentEntity.m_32055_();
                if (fragStack.m_41720_() != ModItems.SOUL_FRAGMENT.get()) continue;
                BlockPos pos = fragmentEntity.m_20183_();
                BlockState state = level.m_8055_(pos.m_7495_());
                if (state.m_60713_(Blocks.f_50724_) && (Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) <= 0) {
                    return;
                }
                ItemEntity stoneEntity = (ItemEntity)stones.get(pos);
                if (stoneEntity == null || (tag = fragStack.m_41783_()) == null || !tag.m_128441_("StoredEntity") || !(storedEntityTag = tag.m_128469_("StoredEntity")).m_128441_("id") || (entityId = storedEntityTag.m_128461_("id")).isEmpty() || (candidates = entityId.equals("minecraft:player") ? level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(1.5), e -> e.m_6095_() == EntityType.f_20492_) : level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(1.5), e -> {
                    ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_());
                    return key != null && entityId.equals(key.toString());
                })).isEmpty()) continue;
                LivingEntity sacrifice = (LivingEntity)candidates.get(0);
                ServerLevel server = (ServerLevel)level;
                if (entityId.equals("minecraft:player")) {
                    String uuidStr = storedEntityTag.m_128461_("UUID");
                    if (uuidStr != null && !uuidStr.isEmpty()) {
                        UUID uuid = UUID.fromString(uuidStr);
                        ServerPlayer revivedPlayer = server.m_7654_().m_6846_().m_11259_(uuid);
                        if (revivedPlayer == null || revivedPlayer.f_8941_.m_9290_() != GameType.SPECTATOR) continue;
                        revivedPlayer.m_20258_(storedEntityTag);
                        revivedPlayer.m_8999_(server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                        revivedPlayer.m_21153_(1.0f);
                        revivedPlayer.m_36324_().m_38705_(3);
                        revivedPlayer.m_36324_().m_38717_(0.0f);
                        revivedPlayer.m_143403_(GameType.SURVIVAL);
                        int duration = 12000;
                        revivedPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19612_, duration, 1));
                        revivedPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 1));
                        revivedPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 1));
                        revivedPlayer.m_5496_(SoundEvents.f_12090_, 1.0f, 1.0f);
                    }
                } else {
                    Entity created;
                    EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityId));
                    if (type == null || !((created = type.m_20615_(level)) instanceof LivingEntity)) continue;
                    LivingEntity revived = (LivingEntity)created;
                    revived.m_20258_(storedEntityTag);
                    revived.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                    revived.m_21153_(1.0f);
                    level.m_7967_((Entity)revived);
                    revived.m_5496_(SoundEvents.f_12090_, 1.0f, 1.0f);
                }
                server.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 40, 0.5, 0.5, 0.5, 0.05);
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                if (lightning != null) {
                    lightning.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
                    lightning.m_20874_(true);
                    level.m_7967_((Entity)lightning);
                }
                level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 2.0f, Level.ExplosionInteraction.BLOCK);
                fragmentEntity.m_146870_();
                stoneEntity.m_146870_();
                sacrifice.m_6074_();
                level.m_46597_(pos.m_7495_(), Blocks.f_50016_.m_49966_());
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_21153_(1.0f);
                serverPlayer.m_36324_().m_38705_(0);
                serverPlayer.m_36324_().m_38717_(0.0f);
                int duration = 12000;
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19612_, duration, 1));
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 1));
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 1));
            }
        }
    }
}

