/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.network;

import com.playerstats.event.PlayerAttributePersistence;
import com.playerstats.util.AttributeUtils;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ModifyAttributePacket {
    private final int entityId;
    private final String attributeId;

    public ModifyAttributePacket(int entityId, String attributeId) {
        this.entityId = entityId;
        this.attributeId = attributeId;
    }

    public static void encode(ModifyAttributePacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130070_(msg.attributeId);
    }

    public static ModifyAttributePacket decode(FriendlyByteBuf buf) {
        return new ModifyAttributePacket(buf.readInt(), buf.m_130277_());
    }

    public static void handle(ModifyAttributePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            Entity entity;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (entity = (level = player.m_9236_()).m_6815_(msg.entityId)) instanceof LivingEntity) {
                AttributeInstance instance;
                LivingEntity living = (LivingEntity)entity;
                Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(ResourceLocation.m_135820_((String)msg.attributeId));
                if (attribute != null && (instance = AttributeUtils.getAttributeInstance(living, attribute)) != null) {
                    PlayerAttributePersistence.upgradeAttribute(living, player, msg.attributeId);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

