/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats;

import com.mojang.brigadier.CommandDispatcher;
import com.playerstats.Config;
import com.playerstats.ModAttributes;
import com.playerstats.client.KeyBindings;
import com.playerstats.command.PlayerStatsCommands;
import com.playerstats.items.ModItems;
import com.playerstats.network.PacketHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="playerstats")
@Mod.EventBusSubscriber(modid="playerstats")
public class PlayerStats {
    public static final String MODID = "playerstats";
    public static final Logger LOGGER = LogManager.getLogger((String)"playerstats");

    public PlayerStats() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER);
        PacketHandler.register();
        ModItems.register(modEventBus);
        ModAttributes.ATTRIBUTES.register(FMLJavaModLoadingContext.get().getModEventBus());
        modEventBus.addListener(this::addCreative);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        KeyBindings.register();
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        PlayerStatsCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onConfigReload(ModConfigEvent event) {
        if (event.getConfig().getSpec() == Config.SERVER) {
            Config.reloadCustomMobChances();
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if (name != null && name.m_135827_().equals("minecraft") && name.m_135815_().startsWith("chests/")) {
            LootPool pool1 = LootPool.m_79043_().name("upgrade_or_crystal_pool").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.UPGRADE_RUNE.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.07f))).m_79707_(1).m_79711_(1)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ABILITY_CRYSTAL.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))).m_79707_(1).m_79711_(1)).m_79082_();
            LootPool pool2 = LootPool.m_79043_().name("attribute_boost_scroll_pool").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ATTRIBUTE_BOOST_SCROLL.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.12f))).m_79707_(1).m_79711_(1)).m_79082_();
            event.getTable().addPool(pool1);
            event.getTable().addPool(pool2);
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.UPGRADE_RUNE);
            event.accept(ModItems.ATTRIBUTE_BOOST_SCROLL);
            event.accept(ModItems.ABILITY_CRYSTAL);
        }
    }
}

