/*
 * Decompiled with CFR 0.152.
 */
package com.playerstats.event;

import com.playerstats.ModAttributes;
import com.playerstats.entities.goals.DefendOwnerTargetGoal;
import com.playerstats.entities.goals.FollowOwnerGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="playerstats")
public class ModAbilityEvents {
    @SubscribeEvent
    public static void onHorseTamed(AnimalTameEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)livingEntity;
            horse.getPersistentData().m_128362_("Owner", event.getTamer().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((Mob)horse));
        }
        if ((entity = event.getEntity()) instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            golem.f_21346_.m_25352_(1, (Goal)new DefendOwnerTargetGoal(golem));
            golem.f_21346_.m_25352_(3, (Goal)new FollowOwnerGoal((Mob)golem));
        }
    }

    @SubscribeEvent
    public static void onHorseTick(LivingEvent.LivingTickEvent event) {
        try {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof AbstractHorse)) {
                return;
            }
            AbstractHorse horse = (AbstractHorse)livingEntity;
            Level level = horse.m_9236_();
            if (level.f_46443_) {
                return;
            }
            if (horse.m_21204_().m_246600_((Holder)ModAttributes.FROST_WALKER.getHolder().get()).m_22135_() == 1.0) {
                BlockPos pos = horse.m_20183_();
                int frostLevel = 1;
                FrostWalkerEnchantment.m_45018_((LivingEntity)horse, (Level)level, (BlockPos)pos, (int)frostLevel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

