/*
 * Decompiled with CFR 0.152.
 */
package de.fisch37.betterserverpacksfabric;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import de.fisch37.betterserverpacksfabric.Main;
import de.maxhenkel.configbuilder.ConfigBuilder;
import de.maxhenkel.configbuilder.entry.ConfigEntry;
import java.util.Optional;
import net.minecraft.class_10846;
import net.minecraft.class_10900;
import net.minecraft.class_2178;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public ConfigEntry<String> url;
    public ConfigEntry<Boolean> rehashOnStart;
    public ConfigEntry<Boolean> required;
    public ConfigEntry<String> prompt;
    private static final DynamicOps<class_2520> OPS = class_2509.field_11560;
    private static final class_10846<class_2520> PARSER = class_10900.method_68618(OPS);

    public Config(ConfigBuilder builder) {
        this.url = builder.stringEntry("url", "", new String[0]);
        this.rehashOnStart = builder.booleanEntry("rehash_on_start", Boolean.valueOf(false), new String[0]);
        this.required = builder.booleanEntry("required", Boolean.valueOf(false), new String[0]);
        this.prompt = builder.stringEntry("prompt", "", new String[0]);
    }

    public Optional<class_2561> getPrompt(@NotNull class_7225.class_7874 registries) {
        String promptString = (String)this.prompt.get();
        if (promptString.isBlank()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Config.textFromSnbt(promptString, registries));
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to parse prompt text " + promptString, (Throwable)e);
            return Optional.empty();
        }
    }

    @Contract(value="null, null -> _; !null, !null -> _")
    public ConfigEntry<String> setPrompt(@Nullable class_2561 prompt, @Nullable class_7225.class_7874 registries) {
        if (prompt == null) {
            this.prompt.set((Object)"");
        } else {
            assert (registries != null);
            this.prompt.set((Object)Config.textToSnbt(prompt, registries));
        }
        return this.prompt;
    }

    private static class_2561 textFromSnbt(String snbt, @Nullable class_7225.class_7874 registries) throws CommandSyntaxException {
        StringReader reader = new StringReader(snbt);
        class_6903 ops = registries == null ? OPS : registries.method_57093(OPS);
        return (class_2561)PARSER.method_68239((DynamicOps)ops, PARSER, class_8824.field_46597, class_2178.field_9842).method_58341(reader);
    }

    private static String textToSnbt(class_2561 text, class_7225.class_7874 registries) throws IllegalStateException {
        class_2520 element = (class_2520)class_8824.field_46597.encodeStart((DynamicOps)registries.method_57093(OPS), (Object)text).getOrThrow();
        return element.toString();
    }
}

