/*
 * Decompiled with CFR 0.152.
 */
package de.fisch37.betterserverpacksfabric;

import de.fisch37.betterserverpacksfabric.Config;
import de.fisch37.betterserverpacksfabric.PackCommand;
import de.fisch37.betterserverpacksfabric.ResourcePackHandler;
import de.maxhenkel.configbuilder.ConfigBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "betterserverpacks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"betterserverpacks");
    private static final byte SHA1_HASH_SIZE = 20;
    public static Config config;
    private static byte @Nullable [] hash;
    private static final HexFormat HEX_FORMAT;

    public void onInitializeServer() {
        config = (Config)ConfigBuilder.builder(Config::new).path(Main.getModConfigFile()).strict(true).saveAfterBuild(true).build();
        Main.readHash();
        if (((Boolean)Main.config.rehashOnStart.get()).booleanValue()) {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                Main.updateHash();
                Main.config.rehashOnStart.set((Object)false).save();
            });
        }
        PackCommand.register();
        ResourcePackHandler.register();
    }

    public static Path getModConfigFolder() {
        return Path.of(".", new String[0]).resolve("config").resolve(MOD_ID);
    }

    public static Path getModConfigFile() {
        return Main.getModConfigFolder().resolve("config.properties");
    }

    public static File getHashFile() {
        return Main.getModConfigFolder().resolve("pack.sha1").toFile();
    }

    public static byte @Nullable [] getHash() {
        return hash;
    }

    @Nullable
    public static String getHashString() {
        byte[] hash = Main.getHash();
        return hash == null ? null : Main.printHexBinary(hash);
    }

    private static void saveHash() {
        if (hash == null) {
            Main.getHashFile().delete();
        } else {
            try (FileWriter file = new FileWriter(Main.getHashFile());){
                file.write(Main.printHexBinary(hash));
            }
            catch (IOException e) {
                LOGGER.error("Failed to write pack hash to file. Hash update will not carry over restarts.");
            }
        }
    }

    private static void readHash() {
        String newHashHex;
        if (((String)Main.config.url.get()).isEmpty()) {
            hash = null;
            return;
        }
        try (BufferedReader file = new BufferedReader(new FileReader(Main.getHashFile()));){
            newHashHex = file.readLine();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("No hash file found, you will need to execute /pack reload to apply");
            hash = null;
            return;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read hash: IOException");
            hash = null;
            return;
        }
        if (newHashHex.length() != 40) {
            LOGGER.error("Pack hash had incorrect length. Assuming false value");
            Main.saveHash();
            return;
        }
        hash = Main.readHexBinary(newHashHex);
    }

    public static CompletableFuture<@Nullable Boolean> updateHash() throws IllegalStateException {
        URL url;
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (((String)Main.config.url.get()).isEmpty()) {
            hash = null;
            future.complete(false);
            return future;
        }
        try {
            url = new URI((String)Main.config.url.get()).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException("Pack URL has invalid format", e);
        }
        new Thread(() -> {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("JVM does not have SHA-1 hashing... WTF?");
                future.complete(null);
                return;
            }
            try (InputStream data = url.openStream();){
                new DigestInputStream(data, digest).readAllBytes();
            }
            catch (IOException e) {
                LOGGER.error("Failed to load resource pack at {}", (Object)url);
                future.complete(null);
                return;
            }
            hash = digest.digest();
            Main.saveHash();
            future.complete(true);
        }, "BSPReloadThread").start();
        return future;
    }

    public static String printHexBinary(byte @NotNull [] val) {
        return HEX_FORMAT.formatHex(val);
    }

    public static byte[] readHexBinary(@NotNull String val) {
        return HEX_FORMAT.parseHex(val);
    }

    static {
        HEX_FORMAT = HexFormat.of();
    }
}

